/* OdmNullDocument.java 0.05         UTF-8                  dh:2006-12-17
 *
 * The OdmNullDocument class implements the common null behaviors for
 * all of the info.odma.practical100 document classes.  This class is
 * not used independently.  It is a foundation that is extended to
 * implement the OdmNullPending and OdmNullWorking classes.
 *
 * The OdmNullDocument classes are also extended for the odmjni non-null
 * implementations.  Every non-null implementation requires the ability to
 * deliver null behaviors and that is accomplished by the having access to
 * the null implementations available through their superclasses, including
 * these OdmNullDocument behaviors.
 *
 * FIXME: The implementation of non-null classes may lead to adjustments
 *    in this underlying class, especially in the sharing of the cache of
 *    null implementations.  It may be that these null-specific cases may
 *    not require any change.  Review should be performed until that is
 *    clear.
 */

package info.odma.practical100;

class OdmNullDocument
{

    /* Instance Variables and Constructor
     * ----------------------------------
       */

    protected final int nullFlavor;
        /* There are three flavors of null implementation for any class of
           OdmDocument implementation:

                0 Failed with false returned by all of operationSucceeded(),
                  operationCancelled(), and localOperationRequested()

                1 with only operationCancelled() returning true

                2 with only localOperationRequested() returning true

           */

    OdmNullDocument(int myFlavor)
    {   /*  Simply remember to do what we're told */

        nullFlavor = myFlavor;

        }   /* OdmNullDocument constructor */



    /* OdmInterface Method Implementations
     * -----------------------------------
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return "ODMJNI 1.0 0.05 (0.30alpha) OdmNullDocument";
            /* This method will often be over-ridden to provide more
               detail of possible use in trouble-shooting and confirmation
               of correct operation. */
        }


    public boolean available()
    {   /* There is no ODMA Connection Manager available. */

        return false;

        } /* available() */


    public void release()
    {   /* There are no resources that require release.  We let the default
           finalize handle everything.
           */

        return;
        }


    /* OdmDocument Interface Method Implementations
     * --------------------------------------------
     */

    public boolean dmsAvailable()
    {   /* There is no DMS available. */

        return false;
        }


    public boolean operationSucceeded()
    {   /* The operation that returned this interface did not succeed. */

        return false;
        }


    public boolean operationCancelled()
    {   /* This flavor is never generated by OdmNullConnection but it
           arises in non-null behaviors.  */

        if (nullFlavor == 1) return true;

        return false;

        }


    public boolean localOperationRequested()
    {   /* This flavor is used wherever, in OdmNullConnection operations
           and documents, it is also possible as a non-null connection
           result.  This provides the proper fallback when ODMA functions
           are not available or have failed in ways not to be exposed to
           the application.
           */

        if (nullFlavor == 2) return true;

        return false;

        }


    } /* OdmNullDocument */


/* 0.05 2006-12-17-17:59 Review for any adjustments required by null-on-null
        and failure-modes.
   0.04 2006-12-16-22:52 Eliminate the retained nullImplementation and
        only make use of it during specific null document constructors,
        not OdmNullDocument.  This must be done in a way where unlimited
        instructor recursion will not result.
   0.03 2006-12-16-14:42 Upgrade with new interfaces and behaviors for
        0.30beta.
   0.02 2006-10-23-15:06 Eliminate global dependency in the constructor,
        since there is no need for these null documents to have any
        global context.  Expanded constructors may be valuable for other
        purposes later.
   0.01 2006-10-22-23:47 Clean up access privileges.
   0.00 2006-10-22-22:05 alpha-level version for the first evolutionary
        prototype of the OdmNullDocument implementation.  This class will
        be maintained consistent with the OdmDocument interface and its
        null behaviors as the prototype package is evolved.

   $Header: /ODMdev/info/odma/practical100/OdmNullDocument.java 6     06-12-17 18:04 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmNullDocument.java ***     */