/* Null01.java 0.00                  UTF-8                   dh:2006-12-17
 *
 * Null01 is a Java application for verification of the 0.30alpha level
 * of the info.odma.practical100.OdmNullConnection class, its interface, and
 * the null documents that it produces.
 *
 * This version is not a comprehensive test of null behavior.  It is only
 * a regression test of the 0.30alpha level against the 0.20alpha level of
 * the basic interfaces and null implementations.   As a regression, it only
 * examines those methods of the practical100 interface that existed in
 * the 0.20alpha release.  This test is simply to establish basic confidence
 * in the working of the compiled interfaces and null implementations.
 *
 * A more-comprehensive version, to be started after the 0.50beta release,
 * will be part of an exhaustive test suite of null-implementation and
 * released-interface behaviors.
 *
 *  FIXME:  The method used in this version should be replaced by one that
 *     reports the null and only the null aspects of the extension from
 *     OdmConnection to the farthest reachable leaves.
 *
 *     Then it should release those objects and confirm the complete
 *     behavior of the released interfaces.
 *
 *     In doing this, the exercises should be broken up into some helper
 *     classes that can be used to construct analyzers and test harnesses
 *     of greater power.
 */


import info.odma.practical100.*;


public class Null01
{/* Exercise the interfaces supplied by the OdmNullConnection 0.30alpha
    level.  The following interfaces are confirmed:

          OdmConnection implemented by OdmNullConnection
     OdmPendingDocument delivered by OdmConnection.acceptNewDocument()
     OdmWorkingDocument delivered by OdmConnection.chooseDocument()

    We have not provided confirmation that there is the same result for
    OdmConnection.openKnownDocument(SomeDocID).  This and some other
    features would be useful to test when we are in the stabilization
    stage of ODMJNI 1.0 delivery.
    */


    private static void hello(IConOut console)
    {   /* Identify the application and what we are doing here.
           */

        console.println();
        console.println("Null01> "
                            + "0.00 OdmNullConnection Test");
        }


    private static final String indent = "        ";
            /* Indent spaces below       "Null00> ". */

    private static final String stars =  "      **** ";
            /* Used to highlight unexpected results */


    private static void goodbye(IConOut console)
    {   /* Announce completion of operation */

        console.println();
        console.println("Null01> exit");
        console.println();
        }


    private static final IConOut
        stdout = new ConWriter(java.lang.System.out);
                     /* use a default console-output implementation */




    public static void main(String[] args)
    {   /*  Console application for reading pairs of doubles and comparing
            them via Math.max and conditional expression.
            */
        hello(stdout);
            /*  identifying ourselves. */

        OdmConnection testConnection
                        = OdmNullBind.application("OdmNativeTest");
            /* Using the 0.30alpha initial-binding model. */

        stdout.println();

        showNullConnection(stdout, indent, testConnection);

        goodbye(stdout);
            /* confirming completion. */

        } /* main */


    private static void
        showNullConnection( IConOut out,
                            java.lang.String indent,
                            OdmConnection testConn )

    {/* Show what's expected, and what's not, by parts. */

        java.lang.String dentx = indent + "  ";

        out.println(indent + "> ANALYSIS OF NULL CONNECTION:");

        checkNullConnection(out, dentx, testConn);

        out.println();
        out.println(indent + "> > ANALYSIS OF NULL PENDING DOCUMENT:");
        out.println(indent + "    checking Null Connection "
                           + "acceptNewDocument()"
                           );

        OdmPendingDocument testPend = testConn.acceptNewDocument(".txt");
            /* choosing a Document Format Name that works with the
               ODMASAMP database. */

        checkNullPending(out, dentx + "  ", testPend);

        out.println();
        out.println(indent + "> > ANALYSIS OF NULL WORKING DOCUMENT:");
        out.println(indent + "    checking Null Connection "
                           + "chooseDocument()"
                           );

        OdmWorkingDocument testWork = testConn.chooseDocument();

        checkNullWorking(out, dentx + "  ", testWork);

        /* FIX ME: If a connection shows as available, we probably
           should stop after the connection report and not do any
           further poking around.
           */

        } /* showNullConnection */


    private static void
        checkNullInterface( IConOut out,
                            java.lang.String indent,
                            OdmInterface testIface)

    {   /* Check out all parts that shouldn't side-effect. */

        out.println(indent + testIface.interfaceImplementation());
        out.println(indent + "Object " + testIface);
        out.println();

        checkBoolean(out, indent + "available()",
                          false, testIface.available() );

        if (testIface.available())
             out.println(stars + "testing release() unsafe here.");
        else out.println(indent
                            + "release() is not checked.");
        /* FIXME: Fundamentally, release() must be checked after
           everything else, where all values are saved and then the
           difference, if any, following release() is checked for.
           */
        }


    private static void
        checkNullConnection(IConOut out,
                            java.lang.String indent,
                            OdmConnection testIface)

    {   /* Show the super class, then the connection parts. */

        checkNullInterface(out, indent, testIface);

        out.println();

        checkBoolean(out, indent + "dmsDefaultAvailable()",
                     false, testIface.dmsDefaultAvailable() );

        out.println(indent + "acceptNewdocument(\".txt\") not checked");
        out.println(indent + "chooseDocument() not checked");
        out.println(indent + "openKnownDocument() not checked");

        }


    private static void
        checkNullDocument(IConOut out,
                           java.lang.String indent,
                           OdmDocument testDocFace)

    {   /* Show the super class, then the connection parts. */

        checkNullInterface(out, indent, testDocFace);

        out.println();

        checkBoolean(out, indent + "dmsAvailable()",
                     false, testDocFace.dmsAvailable() );
        checkBoolean(out, indent + "operationSucceeded()",
                     false, testDocFace.operationSucceeded());
        checkBoolean(out, indent + "operationCancelled()",
                     false, testDocFace.operationCancelled());
        checkBoolean(out, indent + "localOperationRequested()",
                     true, testDocFace.localOperationRequested());

        }


    private static void
        checkNullPending(IConOut out,
                         java.lang.String indent,
                         OdmPendingDocument testPending)

    {   /* Show the super class, then the connection parts. */

        checkNullDocument(out, indent, testPending);

        out.println();

        checkString(out, indent + "docSubmissionLocation()",
                    null, testPending.docSubmissionLocation() );

        }


    private static void
        checkNullWorking(IConOut out,
                         java.lang.String indent,
                         OdmWorkingDocument testWorking)

    {   /* Show the super class, then the connection parts. */

        checkNullDocument(out, indent, testWorking);

        out.println();

        checkString(out, indent + "docID()",
                    null, testWorking.docID() );

        checkString(out, indent + "docLocation()",
                    null, testWorking.docLocation() );

        }


    private static void
        checkBoolean(IConOut out,
                     java.lang.String title,
                     boolean expected,
                     boolean actual )

    {   /* Report on Boolean match or not. */

        out.print(title + " = " + actual);

        if (expected == actual)
             out.println(", as expected.");
        else { out.println();
               out.println(stars + expected + " was expected." + stars);
               }

        }


    private static void
        checkString(IConOut out,
                    java.lang.String title,
                    java.lang.String expected,
                    java.lang.String actual )

    {   /* Report on String match or not. */

        out.print(title + " = " + actual);

        if (expected == actual)
             out.println(", as expected.");
        else { out.println();
               out.println(stars + expected + " was expected." + stars);
               }

        }




} /* Null01 */


/* 0.00 2006-12-17-21:09 Customized from Null00 0.04 as a regression check
        on the changes to the API and methods introduced for 0.30alpha.

   $Header: /ODMdev/info/odma/practical100/test/Null01/Null01.java 12    06-12-17 21:16 Orcmid $
   */

/*                          *** end of Null01.java ***              */
