/* OdmNullWorkingDocument.java 0.07  UTF-8                  dh:2007-01-07
 *
 * The OdmNullWorkingDocument class implements the default null behaviors
 * for OdmWorkingDocument interfaces.  OdmNullDocument is extended
 * to provide the standard default null behavior for working documents,
 * including all of the OdmViewingDocument methods.
 */

package info.odma.practical100;

public class OdmNullWorkingDocument
            extends OdmNullDocument
            implements OdmWorkingDocument

{   /* Class instance construction */

    protected OdmNullWorkingDocument(int myFlavor)
    {   /* We simply expand the OdmNullDocument operation */

        super(myFlavor);

        } /* OdmNullWorkingDocument */


    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return "ODMJNI 1.0 OdmNullWorkingDocument 0.07 OdmWorkingDocument";
            /* Over-ride with our identification. */

            /* FIXME: We could show our flavor too.
                  We also don't have to show the alpha release
                  level.  Our version is enough. */
        }


    /* OdmDocument Interface Method Implementations
     * --------------------------------------------
     *
     * The implementations of OdmNullDocument are all applicable here.
     */


    /* OdmViewingDocumentDocument Interface Method Implementations
     * ---------------------------------------------------
     */

    public boolean viewOnly()
    {   /* We report the default, which is not particularly meaningful
           for a null-document either way. */

        return false;

        } /* viewOnly */



    public java.lang.String docID()
    {   /* No document connection has been established */

        return null;

        } /* docID */



    public java.lang.String docLocation()
    {   /* No document content has been delivered and there is no
           location. */

        return null;

        } /* docLocation */


    public java.lang.String windowTitle()
    {   /* We have no recommendation of a windowTitle for a no-document
           situation */

        return null;

        } /* windowTitle */



    public java.lang.String dmsAuthor()
    {   /* An invisible document has an invisible author ... */

        return null;

        } /* dmsAuthor */



    public java.lang.String dmsDocName()
    {
        return null;

        } /* dmsDocName */



    public java.lang.String dmsDocType()
    {
        return null;

        } /* dmsDocType */



    public java.lang.String dmsFormatName()
    {
        return null;

        } /* dmsFormatName */



    public OdmPendingDocument transferToNewDocument
                                    (java.lang.String docFormatName)
                              throws OdmError
    {   /* There is no document to transfer and attempting to do so
           is invalid. */

        /* FIXME: The docFormatName should be validated first and
                and that case thrown if appropriate.
           */

        throw new OdmError("invalid transferToNewDocument: "
                            + interfaceImplementation() );

        } /* transferToNewDocument */


    /* OdmWorkingDocument Interface Method Implementations
     * ---------------------------------------------------
     */


    public boolean commitChanges()
                        throws OdmError

    {   /* There is no document for which a commit can be entertained,
           and the request is an unrecoverable defect of the application.
           */

        throw new OdmError("invalid commitChanges: "
                            + interfaceImplementation() );

        } /* commitChanges */



    } /* OdmNullWorkingDocument */


/* 0.07 2007-01-07-23:14 Make constructor protected.
   0.06 2007-01-07-22:59 Make public for use by OdmJniView.
   0.05 2006-12-17-22:28 Correct visibility of viewOnly() for clean
        compile.
   0.04 2006-12-17-18:52 Adjust to use the simplified null-document model
        and with unchecked exceptions and null-on-null behavior.
   0.03 2006-12-16-23:16 Change to implement all of the OdmViewingDocument
        and OdmWorkingDocument interface elements, caching null implementa-
        tions internal to the instance.
   0.02 2006-10-23-15:23 Eliminate linking to the connection instance from
        the null document.  The cyclic dependency is unnecessary.
   0.01 2006-10-23-00:47 adjust access privileges of methods to be public
        for the interface implementation, although the class remains
        package-private.
   0.00 2006-10-22-23:13 alpha-level version for the first evolutionary
        prototype of the OdmNullWorkingDocument implementation.  This class
        will be maintained consistent with the OdmWorkingDocument interface
        and its null behaviors as the prototype package is evolved.

   $Header: /ODMdev/info/odma/practical100/OdmNullWorkingDocument.java 7     07-01-07 23:17 Orcmid $
   */

/*   *** end of info.odma.practical100.OdmNullWorkingDocument.java ***   */