/* OdmError.java 0.04                UTF-8                   dh:2007-03-01
 *
 * The OdmError class implements the package-wide unchecked exception
 * for use in verification of parameter strings and for rejection of
 * erroneous document-manipulation operations in null documents.
 *
 * This package-local class extends java.lang.Exception and produces
 * unchecked exceptions.  Thrown exceptions provide a string that describes
 * the triggering behavior and source of the exception.
 *
 * For ODMJNI 1.0, these errors are thrown by constructions such as
 *
 *      throw new OdmError
 *                      ( "Ill-formed [method] [parameter] parameter: "
 *                         + interfaceImplementation() );
 * and
 *
 *      throw new OdmError
 *                      ( "Invalid [method] operation: "
 *                          + interfaceImplementation() );
 *
 * where the interfaceImplementation string is used whenever available.
 *
 */


package info.odma.practical100;

public class OdmError extends java.lang.Error
{
    /* Instance Variables and Constructor
     * ----------------------------------
     *
     * There are no new elements in OdmError.
     *
     * FIXME: Consider overloading the constructor or adding more flavors
     *    as part of simplifying the cases creation of explanatory strings
     *    when these exceptions are thrown.  It is conceivable that there
     *    might be subclasses of OdmError as well.
     *
     */

    public OdmError(java.lang.String message)
    {   /* XXX: It would be great to have this class not be throwable by
                anything but the practical100 and odmjni100 classes.
                The current approach doesn't provide for that.
           */

        super(message);

        } /* OdmError */


    } /* OdmError */


/* 0.04 2007-03-01-14:42 Document the format for error messages created
        within ODMJNI.
   0.03 2006-12-18-13:53 Make public class and constructor for use by
        odmjni100 implementation, for one.
   0.02 2006-12-17-22:31 make explicit constructor that works here.
        This Class is only package visible and we want it that way until
        we have to do something else. (Part of limiting visibility of
        components as long as possible, and opening up just the minimum.)
   0.01 2006-12-17-20:09 corrections to get clean compile
   0.00 2006-12-17-09:47 Introduction for use in 0.30alpha handling of
        erroneuous document-manipulation operations in null-document
        instances.

   $Header: /ODMdev/info/odma/practical100/OdmError.java 5     07-03-01 15:03 Orcmid $
   */

/*        *** end of info.odma.practical100.OdmError.java ***         */