/* OdmInterface.java 0.09            UTF-8                    dh:2007-03-01
 *
 * OdmInterface provides common features that apply to all interfaces of the
 * info.odma.practical100 package.  The methods are defined in this one
 * place for consistent definition and maintenance.
 *
 * The interfaces OdmConnection and OdmDocument each extend OdmInterface.
 * There is no ODMJNI object that implements only OdmInterface.
 */

package info.odma.practical100;

public interface OdmInterface
{
    java.lang.String interfaceImplementation();
        /* text that identifies the implementation of the interface.
           This string is useful in troubleshooting and in identifying
           the implementation in logs and displays.

           This string provides a technical identification and need not
           be localized.

           The standard format for ODMJNI is as follows:

                "ODMJNI 1.0 <class name> <version m.n>"

           It is not necessary to identify the interface being implemented.
           Class names are usually shown without the package prefix.
           */

    boolean available();
        /* True when ODMA is installed for use on the computer where
           the application is running and it is reachable via the
           implementation of this interface.

           If true is returned, that will continue to be the result until
           the interface is released.

           When the result is false, all operations provide their null
           behavior.  Once false is returned, no other result is possible.

               Null behavior: false is returned.
           */

    void release();
        /* Used by applications to announce that no further use of the
           individual interface implementation instance is required.
           Resources associated with the instance will be released as soon
           as all other dependencies on them are also released.  They are
           immediately unavailable via this interface.

           Using release() expedites early return of resources and may
           improve system performance.

           Following a release(), the interface will only deliver null
           responses.  The release() impacts every reference by the
           application to the same interface-implementation instance.  Do
           not use this operation when there may be other references that
           require the instance to remain active.

           IMPORTANT: release() on a document interface implementation will
           not automatically commit any content to the DMS.  It will
           abandon any docSubmissionLocation and docLocation, however, and
           release grants permission to delete the location.  See the
           document-interface descriptions for the operations that must be
           used to commit new content and changes to the DMS.

               Null behavior: no operation is performed.
           */

    } /* OdmInterface */


/* 0.09 2007-03-01-15:08 Add description of how the resulting string is
        formatted in ODMJNI 1.0 interface implementations.
   0.08 2006-12-17-12:59 Review for consistency with the null-document
        failure (null-on-null) cases, adding emphasis to the comment on
        release() behavior of document interfaces as well.
   0.07 2006-12-16-21:18 Correct method-name error and make other small
        adjustments to the text.
   0.06 2006-12-13-20:13 Adjust for change of availableConnection to simply
        available.  Rreview all comments to be consistent.
   0.05 2006-12-12-19:10 Update for 0.30beta, with review and cleanup of
        the descriptions.
   0.04 2006-10-22-23:55 Make interface public for availability in public
        extensions.
   0.03 2006-10-22-17:12 Improve comments, add interfaceImplementation().
   0.02 2006-10-22-15:54 Document null behaviors and correct class name
   0.01 2006-10-22-13:56 Obtain clean compile of the new class.
   0.00 2006-10-22-12:50 Derive from common parts of the 0.01alpha
        Connection and Document interfaces.

   $Header: /ODMdev/info/odma/practical100/OdmInterface.java 9     07-03-01 15:12 Orcmid $
   */

/*       *** end of info.odma.practical100.OdmInterface.java ***       */