/* OdmNullBind.java 0.02             UTF-8                   dh:2007-02-28
 *
 * The OdmNullBind class has static methods that mirror the public methods
 * of the odmjni100 OdmJniBind class.
 *
 * This class provides an application() operation that instantiates a null
 * implementation in place of the active implementation of OdmJniBind.
 *
 * Typical start-up is via a statement such as
 *
 *      odmConnection myConnection = OdmNullBind.application("MyAppId");
 *
 * for console applications and
 *
 *      odmConnection myOdma = OdmNullBind.application( "MyAppId",
 *                                                      myWindow );
 *
 * for GUI applications.
 *
 * Any other methods of this class are reserved for private coordination
 * among the practical100 null-implementation classes.
 */

package info.odma.practical100;

public class OdmNullBind
{


    private OdmNullBind()
    {   /* There is no instantiation of this class */
        }   /* OdmNullBind */


    public static
        OdmConnection
            application(java.lang.String appId)
                throws OdmError

    {   /* Associate the specified Application ID with the application
           and deliver an interface appropriate to the achievement of
           a binding or not. */

        /* XXX: We are relying on the OdmNullConnection constructor
                to check the Application ID.  That's fine once we have
                done that.
           */

        return new OdmNullConnection(appId);

        } /* application */



    public static
        OdmConnection
            application(java.lang.String appId,
                         java.awt.Window appWindow)
                throws OdmError

    {   /* Also associate a java application window with the ODMA
           Connection.  This is also expected to be filtered properly
           by the OdmNullConnection constructor.
           */

        return new OdmNullConnection(appId, appWindow);

        } /* application */


    } /* OdmNullBind */



/* 0.02 2007-02-28-20:34 Clean up, add second application method.
   0.01 2006-12-17-20:05 corrections for clean compile.
   0.00 2006-12-17-19:35 Derive as an extremely-simplified version of
        odmjni100 OdmJniBind.

   $Header: /ODMdev/info/odma/practical100/OdmNullBind.java 3     07-02-28 20:42 Orcmid $
   */

/*        *** end of info.odma.practical100.OdmNullBind.java ***         */