/* OdmNullFormat.java 0.02           UTF-8                   dh:2007-03-02
 *
 * The OdmNullFormat class provides null-behavior static methods for
 * verifying string parameters to ODMJNI 1.0 methods.
 *
 * The null behaviors report that a string is ill-formed regardless of its
 * format.  This is useful in making sure that the correct exceptions and
 * reductions of function occur when an ODMJNI method does not receive the
 * proper parameters.  It is easier, as an initial check, than inventing
 * a variety of ill-formed strings as part of a coverage and edge test.
 *
 * The approval of correctly-formed strings is accomplished in the
 * implementation of the OdmFormat class.
 *
 * The OdmFormat classes are not intended to be instantiated.  All behavior
 * is delivered with static methods.
 */

package info.odma.practical100;

public class OdmNullFormat
{   /* This class is intended for use exclusively in practical100, but
       it must be public to be extended by public class OdmFormat.

       XXX: We don't really NEED this separate class.  Because the
            performance here is not a concern, this class and OdmFormat
            are being developed this way simply to demonstrate some
            features of access controls and static classes.
       */

    OdmNullFormat()
    {   /* Leave as package-visible so that OdmFormat can inherit from
           it.
           */

        } /* OdmNullFormat */



    public static

        boolean wfAppId(java.lang.String appId)

    {   return false;

        } /* wfAppId */



    public static

        boolean wfDocFormatName(java.lang.String docFormatName)

    {   return false;

        } /* wfDocFormatName */



    public static

        boolean safeDocId(java.lang.String docId)

    {   return false;

        } /* safeDocId */



    public static

        boolean wfDocId(java.lang.String docId)

    {   return false;

        } /* wfDocId */



    public static

        boolean wfDocIdPrefix(java.lang.String docId)

    {   return false;

        } /* wfDocIdPrefix */



    public static

        java.lang.String prefixDmsId(java.lang.String docId)

    {   return null;

        } /* prefixDmsId */



    } /* OdmNullFormat */



/* 0.02 2007-03-02-13:52 Add safeDocId method.
   0.01 2007-02-28-21:39 Correct for clean compile.
   0.00 2007-02-25-13:43 Make a null-behavior version and see if I can
        inherit from it as an armature for progressive addition of the
        correct filters.  If that works, I have adapted the null-behavior
        pattern to the creation of static classes.

   $Header: /ODMdev/info/odma/practical100/OdmNullFormat.java 3     07-03-02 17:38 Orcmid $
   */

/*       *** end of info.odma.practical100.OdmNullFormat.java ***        */