/* TestSetup01.c 0.02                 UTF-8                 dh:2006-11-06
 *
 * TestSetup01 is intended to provide simple verification of the following
 * aspects of the ODMJNI OdmNative development folder tree.
 *
 *  1. Confirm that the environment variables and paths are set up for
 *     using the native Windows API in a console application.
 *
 *  2. Confirm that the simple .exe files compiled in this way will execute
 *     on other machines without having to be compiled there.
 *
 *  3. Confirm the loading and unloading of the ODMA 2.0 Connection Manager
 *     dynamic link library, ODMA32.dll
 *
 * This is a C Language program.  We will use C Language and native Windows
 * APIs whenever we do not require C++ classes and COM interfaces accessed
 * as C++ abstract classses.  We also use "Clean C" wherever possible.
 */

#include <stdio.h>
    /* For FILE, fputs, stdout, ... */

#include <windows.h>
    /* For all the other goodies. See the Platform SDK Help Documentation
       Windows API Reference. This and other OdmNative applications use
       Windows API Datatypes and Windows API macros and functions.  */


/* AUXILLIARY INPUT-OUTPUT FUNCTIONS
 * *********************************
 */

/*              TestSetup01> */
#define INDENT "             "
#define STARS  "        **** "

static const char indent[] = INDENT;
static const char stars[] =  STARS;


static void hello(FILE *out)
{   /* Tell them who's here. */

    fputs("\nTestSetup01> 0.02 Verify Setup "
               "for ODMJNI OdmNative Reliance on Platform SDK\n",
          out);

    fputs(INDENT "Program " __FILE__ " dated " __TIMESTAMP__ "\n",
          out);
    fputs(INDENT "Compiled at " __TIME__ " on " __DATE__ ,
          out);

    #if defined(__cplusplus)
        fputs(" as C++", stdout);
    #elif defined(__STDC__)
        fputs(" as Standard C", stdout);
    #elif defined(_MSC_VER)
        fputs(" as Visual C", stdout);
    #else
        fputs(" as C Language", stdout);
    #endif
    #if defined(_MSC_EXTENSIONS)
        fputs(" extended", stdout);
    #endif
        fputs("\n\n", stdout);

    } /* hello */


static void goodbye(FILE *out)
{   /* Tell them who's leaving. */

    fputs("\nTestSetup01> exit\n\n", out);
    }


/* MAIN TESTSETUP01 FUNCTION DEFINITION
 * ************************************
 */

int main(const int argc, char* argv[])
{   /* Make simple console application with no command-line parameters.
       This program uses minimalist output statements because we can.
       */

    const char pszConManDLL[] = "ODMA32.dll";

    HINSTANCE hConMan = NULL;
        /* Handle for the ODMA Connection Manager DLL, if loaded
           successfully
           */

    BOOL bConManReleased = FALSE;

    hello(stdout);

    hConMan = LoadLibraryA(pszConManDLL);
        /* XXX: Do not compile with default UNICODE.
           See the Platform SDK Windows API Reference for details of
           this function.
           */
        /* FIXME: It is preferable to specify the exact path to the
           Windows System Library and not do a general search for
           the ConnectionManager.  This must be repaired in production.
           */
        /* FIXME: Error information can be obtained from the runtime
           to determine why this function returns NULL when it does.
           */
        /* FIXME: We are allowing the loader to issue error messages for
           now.  We need to fix that in production since the DLL is not
           required to be present.  Although a failure might be a verbose
           log event, it is not an error if the file is simply not found.
           */


    if (hConMan != NULL)
         { /* Report that the library was loaded. */
           fputs(INDENT "ODMA Connection Manager ", stdout);
           fputs(pszConManDLL, stdout);
           fputs(" is successfully loaded.\n", stdout);
           fputs(INDENT "This allows ODMJNI to report true for "
                 "connectionAvailable().\n", stdout);
           fputs(INDENT "This holds whether or not the DLL is "
                 "usable by the application.\n\n", stdout);
           /* This is also a loggable event for a verbose log */
           }
    else { /* Report that the library was not loaded. */
           fputs(STARS "ODMA Connection Manager ", stdout);
           fputs(pszConManDLL, stdout);
           fputs(" could not be found.\n", stdout);
           fputs(STARS "This forces ODMJNI to report false for "
                 "connectionAvailable().\n", stdout);
           fputs(STARS "This is a normal condition when "
                 "ODMA has not been installed.\n\n", stdout);
           }


    if(hConMan != NULL)
         { /* Release the DLL */

           bConManReleased = FreeLibrary(hConMan);
                /* See the Platform SDK Windows API Reference for
                   details of this function.
                   */

           if (bConManReleased)
                { /* The release was successful */
                  fputs(INDENT "The ODM Connection Manager is now "
                        "released.  For ODMJNI,\n", stdout);
                  fputs(INDENT "this is done only only after all "
                        "references to IodmNative\n", stdout);
                  fputs(INDENT "have been released.\n\n",
                        stdout);
                  }

           else { /* There was a failure in regard to the release */
                  fputs(STARS "Release of the ODM Connection Manager "
                        "failed.\n\n", stdout);
                  /* FIXME: This is definitely a loggable event.
                     There needs to be more error hardening for this situation.  Also, we don't want loader error
                     messages being presented to the user.
                     */
                  }

           hConMan = NULL;

           }

    goodbye(stdout);

    return 0;
    } /* main */


/* 0.02 2006-11-06-15:18 Correct comments and touch up for the version to
        package in the archive posting.
   0.01 2006-10-31-22:13 Add LoadLibrary and FreeLibrary code for the DLL.
   0.00 2006-10-31-19:07 Elementary changes to TestSetup00.c 0.02 just to
        verify that compilation is working with the Setup01 scripts.

   $Header: /MyProjects/java/ODMdev/info/odma/OdmNative100/test/setup01/TestSetup01.c 4     06-11-06 15:19 Orcmid $
   */

/*                          *** end of TestSetup01.c ***                */