/* Check05.cpp 0.00                  UTF-8                    dh:2006-12-20
 *
 *            VERIFY THE IodmNative COM INTERFACE IMPLEMENTATION
 *            **************************************************
 *
 * Check05 provides the a regression confirmation of the 0.30alpha OdmNative
 * integration.   It exercises the basic cases of the 0.30alpha
 * IodmApplication interface.
 *
 * The capabilities confirmed are:
 *
 *   1. All of the functions of the Setup04 test program used to confirm
 *      the 0.20alpha build.
 *
 *   2. Additional 0.30alpha functions as this program is customized to
 *      verify additions as they are made.
 *
 *
 * This is a C++ program.  The COM interfaces that we use are defined as
 * C++ classes and the headers do not provide non-class substitutions when
 * C is being used instead of C++.
 *
 * For the most part, we are still writing "Clean C," but with C++ classes
 * as interface definitions.
 */

#include <stdio.h>
    /* For FILE, fputs, stdout, ... */

#include <string.h>
    /* for strlen in reportIface() */

#include <windows.h>
    /* For standard Windows types, constants, and classes. */

#include "Odma32types100.h"
    /* ODMA types used with OdmNative100 interfaces */

#include "OdmNative100.hpp"
    /* For the only interfaces and functions exercised in Setup04.
       For regression against future versions of OdmNative100 classes
       and interfaces, addition .obj or .lib files may need to be
       included in builds of Setup04.  Nevertheless, only this interface
       is relied upon.



/* AUXILLIARY INPUT-OUTPUT FUNCTIONS
 * *********************************
 */

/*              Check05> */
#define INDENT "         "
#define STARS  "    **** "

static const char indent[] = INDENT;
static const char stars[] =  STARS;



static void hello(FILE *out)
{   /* Tell them who's here. */

    fputs("\nCheck05> 0.00alpha Demonstration of OdmNative100 "
               "0.30alpha Functions.\n",
          out);

    fputs(INDENT "Program " __FILE__ " dated " __TIMESTAMP__ "\n"
          INDENT "Compiled at " __TIME__ " on " __DATE__
    #if defined(__cplusplus)
        " as C++"
    #elif defined(__STDC__)
        " as Standard C"
    #elif defined(_MSC_VER)
        " as Visual C"
    #else
        " as C Language"
    #endif
    #if defined(_MSC_EXTENSIONS)
        " extended"
    #endif
    #if defined(_DLL)
        " DLL"
    #endif
    #if defined(_WIN32)
        " (Win32)"
    #endif
        "\n\n", out);

    } /* hello */



static const char* hResultName(HRESULT rc)
{   /* Return the names of the known HRESULT values */

    switch (rc)
    {   case S_OK:
            return "S_OK";
        case E_NOINTERFACE:
            return "E_NOINTERFACE";
        case E_INVALIDARG:
            return "E_INVALIDARG";
        case E_POINTER:
            return "E_POINTER";
        case E_FAIL:
            return "E_FAIL";
        case E_OUTOFMEMORY:
            return "E_OUTOFMEMORY";
        case E_UNEXPECTED:
            return "E_UNEXPECTED";
        case E_NOTIMPL:
            return "E_NOTIMPL";
        case E_HANDLE:
            return "E_HANDLE";
        }

    return "unknown";

    } /* hResultName */



    static const char* odmStatusName(ODMSTATUS rc)
{   /* Return the names of the known ODMSTATUS values */

    switch (rc)
    {   case ODM_SUCCESS:
            return "ODM_SUCCESS";
        case ODM_E_FAIL:
            return "ODM_E_FAIL";
        case ODM_E_CANCEL:
            return "ODM_E_CANCEL";
        case ODM_E_NODMS:
            return "ODM_E_NODMS";
        case ODM_E_CANTINIT:
            return "ODM_E_CANTINIT";
        case ODM_E_VERSION:
            return "ODM_E_VERSION";
        case ODM_E_APPSELECT:
            return "ODM_E_APPSELECT";
        case ODM_E_USERINT:
            return "ODME_E_USERINT";
        case ODM_E_HANDLE:
            return "ODM_E_HANDLE";
        case ODM_E_ACCESS:
            return "ODM_E_ACCESS";
        case ODM_E_INUSE:
            return "ODM_E_INUSE";
        case ODM_E_DOCID:
            return "ODM_E_DOCID";
        case ODM_E_OPENMODE:
            return "ODM_E_OPENMODE";
        case ODM_E_NOOPEN:
            return "ODM_E_NOOPEN";
        case ODM_E_ITEM:
            return "ODM_E_ITEM";
        case ODM_E_OTHERAPP:
            return "ODM_E_OTHERAPP";
            /* Symbols below here are not defined in Odma32types100.h */
        case 16:
            return "ODM_E_NOMOREDATA (ODMA 1.5 feature)";
        case 17:
            return "ODM_E_PARTIALSUCCESS (ODMA 1.5 feature)";
        case 18:
            return "ODM_E_REQARG (ODMA 2.0 feature)";
        case 19:
            return "ODM_E_NOSUPPORT (ODMA 2.0 feature)";
        case 20:
            return "ODM_E_TRUNCATED (ODMA 2.0 feature)";
        case 21:
            return "ODM_E_INVARG (ODMA 2.0 feature)";
        case 22:
            return "ODM_E_OFFLINE (ODMA 2.0 feature)";
        case 23:
            return "ODM_E_ARCHIVED (ODMA 2.0 UNSPECIFIED)";
        case 24:
            return "ODM_E_ALREADYOPENED (ODMA 2.0 UNSPECIFIED)";
        case 25:
            return "ODM_E_FILELOCKED (ODMA 2.0 UNSPECIFIED)";
        case 26:
            return "ODM_E_REFUSED (ODMA 2.0 UNSPECIFIED)";
        case 27:
            return "ODM_W_NOACTION (ODMA 2.0 UNSPECIFIED)";
        case 28:
            return "ODM_E_NORELATION (ODMA 2.0 UNSPECIFIED)";
        }

    return "(not defined)";

    } /* odmStatusName */



static void reportIface(FILE *out,
                 const char ifaceName[],
                 HRESULT rc,
                 void *pIface)
{   /* Just show the Interface Results that we get */

    int spaces = 19 - strlen(ifaceName);
            /* Number of spaces to put after the name to
               obtain even columns */

    fprintf(out, INDENT "%08p  p%s, ",
                 pIface, ifaceName );

    while(spaces--) fputs(" ", out);

    fprintf(out, "rc = %08X (%s)\n",
                 rc, hResultName(rc) );

    } /* reportIface */



static void reportIodmApp( FILE  *out,
                           BOOL  haveIodmApp
                           )
{   if (!haveIodmApp)
         {  /* Lament having no IodmApplication100 interface */
            fputs("\n" STARS "IodmApplication100 INTERFACE NOT ACQUIRED\n"
                       STARS "    No further operations are possible.\n",
                  out);
            }

    else {  /* Report operations able to begin. */
            fputs("\n" INDENT "> IodmApplication100 "
                              "interface acquired.\n",
                  out);
            }

    } /* reportIodmApp */



static void reportIodmAppVersion(   FILE  *out,
                                  LPCSTR  pszText
                                  )
{   /* Present the version text nicely below the interface-acquired report.
       */

    if (pszText == NULL) return;

    fputs(INDENT "  ", out);

    fputs(pszText, out);
        /* FIXME: The lines need to be broken up and indented.
           ***************************************************
           This can be a bonus activity when cleaning up after
           beta release.
           */

    fputs("\n", out);

    } /* reportIodmAppVersion */



static void reportHasConMan( FILE  *out,
                       BOOL  haveConnectionManager
                           )
{   if (!haveConnectionManager)
         {  /* Lament having no Connection Manager */
            fputs("\n" STARS "CONNECTION MANAGER NOT AVAILABLE\n"
                       STARS "    No ODMA operations are possible and the\n"
                       STARS "    application must behave "
                                 "conventionally.\n",
                  out);
            }

    else {  /* Report operations able to begin. */
            fputs("\n" INDENT "> > An ODMA Connection Manager "
                              "is available to use.\n",
                  out);
            }

    } /* reportHasConMan */



static void reportUnexpectedDMS( FILE  *out,
                                 BOOL  unexpectedDMS
                                 )
{   if (unexpectedDMS)
         {  /* There's a problem here. */
            fputs("\n" STARS "DMS INCORRECTLY REPORTED AVAILABLE.\n"
                       STARS "    No DMS can be available if there is no\n"
                       STARS "    ODMA Connection Manager available.\n",
                  out );
            }

    else {  /* It is expected that there be no unexpected DMS ... */
            fputs(STARS "    As required in this case, there is also\n"
                  STARS "    no DefaultDMS.\n",
                  out );
            }

    } /* reportUnexpectedDMS */



static void reportHasDefaultDMS( FILE  *out,
                                 BOOL  hasDefaultDMS
                                 )
{   fputs("\n", out);

    if (!hasDefaultDMS)
         {  /* There's a limitation here. */
            fputs(INDENT "> > > NO DEFAULT DMS IS AVAILABLE.\n"
                  INDENT "      Operations that apply against a default\n"
                  INDENT "      are unavailable to this application.\n",
                  out);
            }

    else {  /* all ODMA 1.0 operations are available */
            fputs(INDENT "> > > There is a Default DMS for use.\n"
                  INDENT "      All ODMA 1.0 DMS-requiring operations\n"
                  INDENT "      are available to this application.\n",
                  out);
            }

    } /* reportDefaultDMS */



static void reportNoSelect(FILE* out, ODMSTATUS rc)
{   /* Show results of selectDocID operation that didn't return a
       Document ID.
       */

       fputs("\n" INDENT "> > > > No DocID returned from selectDocID.\n"
                  INDENT "        rc = ",
             out);

       fprintf(out, "%d, %s",
                    (int) rc, odmStatusName(rc) );

       switch (rc)
       {    /* Indicate if response is unexpected */
           case ODM_SUCCESS:
           case ODM_E_FAIL:
           case ODM_E_CANCEL:
           case ODM_E_NODMS:
           case ODM_E_APPSELECT:
                fputs("\n", out);
                return;
           }

       fputs(" *** INVALID ***\n", out);

       } /* reportNoSelect */



static ODMSTATUS traceSelectDocID(FILE* out, IodmApplication100 *pIodmApp)

{   /* Exercise the IodmApplication100::selectDocID method, reporting on
       what occurs.
       */

       char pszDocId[ODM_DOCID_MAX+2] = {'\0'};
            /* Buffer for any returned Document ID, with a little
               extra padding.  FIXME: A more serious buffer-overrun guard.
               */

       BOOL viewMode;
            /* Set to indicate whether the document should be opened in
               view mode rather than modify mode. */

       ODMSTATUS rc = ( pIodmApp -> selectDocID(pszDocId, &viewMode) );
            /* OK, let's see what we have. */

       if (rc != ODM_SUCCESS)
            {  /* We have no document.  There is nothing more to do
                  but report the result code. */

               reportNoSelect(out, rc);
               return rc;

               }

       fputs("\n"  INDENT "> > > > A Document ID is selected for ", out);

       if (viewMode)
            fputs("viewing", out);
       else fputs("modification", out);

       fputs(".\n" INDENT "        Doc ID ", out);

       fputs(pszDocId, out);
       fputs("\n\n" INDENT "> > > > No document operation performed.\n",
             out );

       return rc;

       } /* traceSelectDoc */



static void reportGoesDMS(FILE* out)
{   /* Explain how the DMS is released. */

    fputs("\n" INDENT "> > > There is no further need for the Default\n"
               INDENT "      DMS.  It will be released automatically\n"
               INDENT "      when all IodmApplication100 references\n"
               INDENT "      are released.\n",
          out);

    } /* reportGoesDMS */



static void reportGoesConMan(FILE* out)
{   /* Explain how the Connection Manager is released. */

    fputs("\n" INDENT "> > There is no further need for the ODMA\n"
               INDENT "    Connection Manager.  It will be released\n"
               INDENT "    automatically when all IodmApplication100\n"
               INDENT "    interface references are released.\n",
          out );

    } /* reportGoesConMan */



static void reportRelease(FILE *out, const char ifaceName[])
{   /* Just build a bit more statement. */

    fputs(INDENT "> ", out);
    fputs(ifaceName, out);
    fputs(" interface released.\n", out);

    }


static void goodbye(FILE *out)
{   /* Tell them who's leaving. */

    fputs("\nCheck05> exit\n\n", out);
    }



/* APPLICATION-IMPORTANT CONSTANTS
 * *******************************
 */

static const char pszTestAppId[ ] = "OdmNativeTest\0";
    /* The name of the application for all of our tests. Guard with
       an extra null byte.  This is a valid Application ID.
       */

static const IID IID_IodmUnknown = IID_IodmUnknown_ ;
    /* Standard IUnknown IID uniquelly named to avoid conflicts. */

static const IID IID_IodmApplication100 = IID_IodmApplication100_ ;
    /* The provisional IodmApplication100 IID of the current test level. */

static const IID IID_IFoo = /* A never assigned IID used for fun. */
        { 0x12751e61, 0x9ef6, 0x451e,
            { 0x9a, 0xbd, 0xf9, 0x75, 0xad, 0x1d, 0x79, 0x91 } };



/* MAIN CHECK05 FUNCTION DEFINITION
 * ********************************
 */

 int main( int argc, char *argv[])

 {  /* Use simple console application with no command-line parameters.
       */

    /* GUARDED REFERENCE POINTERS AND STATE.  This data is managed
       is as part of an always stable state for the application.
       Values reflect the availability conditions of ODMA to the
       application.
       */

    IUnknown *pIFooUnknown = NULL;
        /* Not expected to produce a valid result.
           This is used solely as a negative confirmation.
           */

    IUnknown *pIodmAppUnk = NULL;
        /* The IUnknown interface of the OdmApplication Object, it
           would seem.  If we acquire this, we use it to Query Interface
           for the next one.
           */

    IodmApplication100 *pIodmApp = NULL;
        /* The Interface that allows us to do a little work.  This is
           the helper level for odmjni100 implementation of the
           info.odma.practical100.OdmConnection interface.
           */

    HRESULT rc = S_OK;
        /* Result code for HRESULT-producing functions and methods. */

    BOOL proceedOK = FALSE;
        /* Boolean result for BOOL-returning interface methods. */

    int releaseCount = 0;
        /* Count of releases done at the end. */

    /* IDENTIFY APPLICATION.  This just shows which test is running.
       */

    hello(stdout);


    /* ACQUIRE THE APPLICATION-LEVEL INTERFACE.  Demonstrate that
       we are (or are not) obtaining the necessary interfaces.
       */

    rc = OdmBindNative100(pszTestAppId, IID_IFoo,
                                        (void**) &pIFooUnknown);
    reportIface(stdout, "IFoo", rc, pIFooUnknown);

    rc = OdmBindNative100(pszTestAppId, IID_IodmUnknown,
                                       (void**) &pIodmAppUnk);
    reportIface(stdout, "IUnknown", rc, pIodmAppUnk);

    if (SUCCEEDED(rc))
         rc = pIodmAppUnk -> QueryInterface( IID_IodmApplication100,
                                             (void**) &pIodmApp );

    else rc = OdmBindNative100(pszTestAppId, IID_IodmApplication100,
                                             (void**) &pIodmApp );

    reportIface(stdout, "IodmApplication100", rc, pIodmApp);


    /* REPORT WHETHER HAVE INTERFACE AND CAN PROCEED
    */

    proceedOK = (pIodmApp != NULL);

    reportIodmApp(stdout, proceedOK);
        /* Reporting whether it is possible to proceed.
           TESTME: There are more cases of proper QueryInterface
           and reference counting.  We need a test fixture for
           that, and also on the defensive measures in the
           IUnknown implementations.*/

    if (proceedOK)
         reportIodmAppVersion(stdout,
                              pIodmApp -> interfaceImplementation() );


    /* DETERMINE AVAILABILITY OF CONNECTION MANAGER
       */

    if (proceedOK)
         {  /* Determine whether we have the Connection Manager
               and can continue.
               */

            proceedOK = ( pIodmApp -> hasConMan() );

            reportHasConMan(stdout, proceedOK);

            if (!proceedOK)

                 reportUnexpectedDMS(stdout, pIodmApp -> hasDefaultDMS() );

            }

    /* DETERMINE AVAILABILITY OF A DEFAULT DMS FOR THE APPLICATION
       */

    if (proceedOK)
         {  /* Determine if we have a default DMS so we can continue
               with operations.
               */

            proceedOK = ( pIodmApp -> hasDefaultDMS() );

            reportHasDefaultDMS(stdout, proceedOK);

            }


    /* HAVE THE DEFAULT DMS CHOOSE A DOCUMENT ID IN COOPERATION WITH
       THE USER.
       */

    if (proceedOK)
         {  /* Use the Default DMS to perform a selectDoc and don't do
               anything with the result. */

            proceedOK = !traceSelectDocID(stdout, pIodmApp);

            }


    /* ACCOUNT FOR THE RELEASE OF RESOURCES THAT ARE BEING HELD. */

    if ( pIodmApp != NULL )
         {  /* Report how the resources will be unwound. */

            if ( pIodmApp -> hasConMan() )

                 {   /* Only cover the legitimate DMS case.  We
                        have complained about any infraction
                        already. */

                     if ( pIodmApp -> hasDefaultDMS() )

                          reportGoesDMS(stdout);

                     reportGoesConMan(stdout);

                     }
            }


    /* GUARDED RELEASE PROCESS.  All interface references are released
       if they are (still) held at the conclusion of the program.

       If any resources have been acquired in the course of
       IodmApplication100 usage, they will be released automatically
       when the last reference to the interface is released.
       */

    fputs("\n", stdout);

    if (pIodmApp != NULL)
        { pIodmApp -> Release(); pIodmApp = NULL;
          reportRelease(stdout, "IodmApplication100");
          ++releaseCount;
          }

    if (pIodmAppUnk != NULL)
        { pIodmAppUnk -> Release(); pIodmAppUnk = NULL;
          reportRelease(stdout, "IUnknown");
          ++releaseCount;
          }

    if (pIFooUnknown != NULL)
        { pIFooUnknown -> Release(); pIFooUnknown = NULL;
          reportRelease(stdout, "IFoo (??)");
          ++releaseCount;
          }

    if (releaseCount > 0)
        fputs("\n", stdout);

    goodbye(stdout);

    return 0;

    } /* main */


/* 0.20 2006-11-25-22:38 Version built as regression check on the 0.20alpha
        OdmNative100 integration.  There are no changes to the logic.  The
        biggest changes are in the Build script for working against the
        OdmNative100.obj and headers in the OdmNative directory.

   0.18 2006-11-24-10:35 Perform regression against 0.19 version of the
        ODMNative100.cpp with GetConsoleWindow() linked all of the time.

   0.17 2006-11-23-22:12 Perform regression against 0.18 version of the
        OdmNative100.cpp with GetVersion() used to avoid spurious calls
        on GetConsoleWindow() for versions earlier than Windows 2000.

   0.16 2006-11-23-21:19 Perform regression against 0.17 version of the
        OdmNative100.cpp with both EnumThreadWindows and GetConsole-
        Window functions.  We are including user32.lib in all builds
        now too.

   0.15 2006-11-23-20:47 Perform regression against 0.16 version of the
        OdmNative100.cpp with its reliance on EnumThreadWindows.

   0.14 2006-11-23-19:18 Perform regression against 0.15 version of the
        OdmNative100.cpp with its reliance on GetConsoleWindow(), a
        Windows Kernel function not supported until Windows 2000 Pro.

   0.13 2006-11-23-18:31 Perform regression against 0.14 version of the
        OdmNative100.cpp with its additional internal interfaces.

   0.12 2006-11-23-14:20 Change name of selectDoc to selectDocID.

   0.11 2006-11-23-13:54 Adjust after selectDoc manages to obtain a
        Document ID (after switching to administrator so ODMASAMP works
        correctly).

   0.10 2006-11-23-11:38 Exercise the selectDoc method and provide a
        report of the different outcomes.

   0.09 2006-11-19-01:42 Add report of interfaceImplementation() for
        the acquired IodmApplication100.  Get the content without pretty
        formatting.

   0.08 2006-11-18-21:25 Add an account for how the resources that are
        held will be released.

   0.07 2006-11-18-17:38 Add Basic Connection Reporting and tidy up the
        display a bit more.

   0.06 2006-11-18-00:02 Correct the string for making a blank line
        after any release counts are reported.

   0.05 2006-11-17-23:58 Clean up the release reporting to line up better.

   0.04 2006-11-16-21:28 Add reporting of the OdmBindNative100 results.

   0.03 2006-11-16-18:48 Do the basic call of OdmBindNative100 and check
        for getting any interfaces.

   0.02 2006-11-16-17:32 Use structure of TestSetup03.c as a fine way
        to report operations here.  Do just the structure without any use
        of OdmBindNative100.

   0.01 2006-11-15-23:00 Adjust to OdmNative100.hpp nomenclature.

   0.00 2006-12-20-16:40 Start by cloning Setup04 0.20 as Check05 and
        producing a clean regression check before we do anything else.

   $Header: /ODMdev/info/odma/OdmNative100/test/check05/Check05.cpp 22    06-12-20 16:41 Orcmid $
   */

/*                        *** end of Check05.cpp ***                  */

