
/* Odma32api100.h 0.11               UTF-8                    dh:2006-11-25
 *
 * ODMA API ENTRY-POINT POINTER DECLARATIONS FOR ODMA 1.0 APPLICATIONS
 *
 *                         Copyright © 2006 NuovoDoc
 *                 Copyright © 1994, 1995 AIIM International
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source code that includes this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMA32API100_H
#define ODMA32API100_H

#include <windows.h>
    /* Needed for types in these declarations and for Odma.h if it
       hasn't been included yet.
       */

#include "Odma32types100.h"
    /* The only ODMA Types that the 1.00 Entry-Points Depend upon.
       */

/* DECLARE FUNCTION-POINTER TYPES FOR THE ODMA32 1.00 API
 * ******************************************************
 *
 *  These entries are only those supported by ODMA 1.0.  There are other
 *  entries that can be discovered, but the presumption is that the
 *  application will declare itself to be an ODMA 1.0 application and
 *  no beyond-1.0 features are required for the application to work
 *  successfully.
 *
 *  The descriptions here specify ODMA 1.0-aware behavior that also adjusts
 *  for breaking changes that were introduced in subsequent versions of
 *  ODMA.  See Incident Report X000002: ODMA Codes Missing in Odma.h at
 *  <http://ODMA.info/support/X000002.htm> and FAQtip Q000705: Changes
 *  Between ODMA Versions at <http://odma.info/downloads/Q000705.htm>.
 */


#ifdef __cplusplus
extern "C" {
    /* There are no external entries defined here, but there are other
       elements that might depend on the programming model, so we leave
       the C++ qualifier in.
       */
#endif


/* ODMSTATUS WINAPI ODMRegisterApp(ODMHANDLE FAR *pOdmHandle,
                                   WORD version,
                                   LSTR lpszAppId,
                                   DWORD dwEnvData,
                                   LPVOID pReserved);
   */

typedef ODMSTATUS (WINAPI *pfnODMREGISTERAPP)
                     (  ODMHANDLE *pOdmHandle,  /* set to session handle */
                             WORD version,      /* minimum ODMA version for
                                                   this application, *100 */
                           LPCSTR lpszAppId,    /* Application ID sz text
                                                   not over ODM_APPID_MAX */
                             HWND hWin,         /* handle of the
                                                   application window that
                                                   modal DMS dialogs are to
                                                   associate with.*/
                           LPVOID
                        );
                     /* FAR is irrelevant for Win32.
                        0.02: make lpszAppId a constant string input. */
                     /* FIXME: Check the Connection Manager code and make
                        sure that it creates its own copy.
                        */

    /* If successful, *pOdmHandle is set to the handle that represents
       this application's connection for default DMS and general ODMA 1.0
       requests.

       If the operation is unsuccessful, *pOdmHandle is set to NULL.

       The possible ODMSTATUS values are

               ODM_SUCCESS  *pOdmHandle has the handle for this application
                            to use

               ODM_E_NODMS  There is no default DMS for this Application ID

            ODM_E_CANTINIT  The default DMS failed to initialize

             ODM_E_VERSION  The version requirement could not be satisfied.
                            XXX - It is not clear that this is handled
                            properly.

                      other For ODMA 1.0 applications, all ODMSTATUS values
                            other than ODM_SUCCESS should be treated as
                            ODM_E_NODMS.  That is the practical consequence.
                            Troubleshooting these cases can be handled by
                            recording an ODMA 2.0 Connection Manager log.
       */



/* void WINAPI ODMUnRegisterApp(ODMHANDLE odmHandle);
   */

typedef void (WINAPI *pfnODMUNREGISTERAPP) (ODMHANDLE);

    /* This operation releases the default DMS and the handle back into the
       default Connection Manager instance that was created by a successful
       RegisterApp operation.  The handle is invalid after this operation.
       There is no ODMSTATUS and there are no error cases.
       */



/* ODMSTATUS WINAPI ODMSelectDoc(ODMHANDLE odmHandle,
                                 LPSTR lpszDocId,
                                 LPDWORD pdwFlags);
   */

typedef ODMSTATUS (WINAPI *pfnODMSELECTDOC)
                     (  ODMHANDLE OdmHandle, /* for a valid ODMA session */
                            LPSTR lpszDocId, /* for the returned Doc ID,
                                                not over ODM_DOCID_MAX */
                          LPDWORD pFlags     /* in-out flags specifying
                                                options and variations */
                        );

    /* This operation invites the default DMS to choose a document for
       the application, performing the appropriate user interactions to
       arrive at a selection.  In an ODMA-aware application that has
       successfully obtained OdmHandle, this operation is to be offered
       prior to presenting the application's build-in file-open dialog,
       unless that dialog has provisions for requesting use of ODMA for
       the document selection.

       The DMS-provided document-selection dialog must always provide
       options that lead to the ODM_E_APPSELECT and ODM_E_CANCEL responses.

       If successful, an ODMA Document ID is stored in lpszDocId[] and
       *pFlags is updated with additional information.

       If unsuccessful, the contents of lpszDocId[] are unpredictable.  The
       *pFlags setting is also unpredictable.

       On input, *pFlags can be 0 or ODM_SILENT.  (It is unusual for a DMS
       to have a silent behavior for selecting documents.  An ODM_E_USERINT
       ODMSTATUS response is likely in that case.)

       The possible ODMSTATUS values are

               ODM_SUCCESS  The Document ID of the User's selection is
                            stored in lpszDocId[] and *flags have been
                            updated with a recommendation on how the
                            document is to be viewed.

              ODM_E_CANCEL  The user closed/cancelled the request.  It is
                            appropriate to treat this response as a
                            cancellation of the user-selected operation
                            rather than treat the same as ODM_E_APPSELECT.
                            [NOTE: A "stuck" ODM_E_CANCEL response can lead
                            to the inability to open any document in the
                            application.  If the user repeats the operation
                            that leads to an already-cancelled request, it
                            may be important to treat another ODM_E_CANCEL
                            as ODM_E_APPSELECT to avoid denying the user
                            an opportunity to do something else.]

           ODM_E_APPSELECT  No choice was made with the DMS.  The user
                            requests that the application's non-ODMA dialog
                            and operations be provided instead.

             ODM_E_USERINT  The DMS requires user interaction for this
                            function.  No operation was performed because
                            *pFlags option ODM_SILENT was specified.

              ODM_E_HANDLE  The OdmHandle parameter is invalid.  This
                            indicates an application error.  There is no
                            meaningful recovery.  It is appropriate to
                            treat this case as an ODM_E_APPSELECT, perhaps
                            with an error indication.  If there is an event
                            log, this situation should be logged to support
                            trouble-shooting as well.

            ODM_E_OTHERAPP  The user used the DMS to select a document in
                            another application.  This response should be
                            treated the same as ODM_E_CANCEL. [NOTE: See the
                            ODM_E_CANCEL note for appropriate behavior when
                            a stuck "ODM_E_OTHERAPP" is suspected.]

                     other  For ODMA 1.0 applications, all ODMSTATUS values
                            other than those listed should be treated as if
                            ODM_E_FAIL had occurred.  (ODM_E_FAIL is defined
                            as a possible ODMRESULT for ODMSelectDoc in ODMA
                            2.0.)  It is recommended that ODM_E_FAIL be
                            treated the same as ODM_E_APPSELECT so the user
                            has a way to continue, with a possible error
                            indication and logging of the event.

       The *pFlags value may have one of these bits set:

            ODM_MODIFYMODE  The selected document should be opened for
                            modification (the default).

              ODM_VIEWMODE  The selected document should be opened for
                            viewing only.

                     other  bits in the flag word should be ignored.

       If no *pFlags bits are set, ODM_MODIFYMODE should be presumed.  If
       both bits are set, take ODM_VIEWMODE as the safe assumption.

       */




/* DEFER ALL OTHERS FOR NOW.
   *************************

   The preceding declarations are sufficient for 0.20alpha OdmNative100.
   A limited number of the following entries will be modified and included
   for use in releases of OdmNative100 having additional functions.
   */



#if 0

ODMSTATUS WINAPI ODMOpenDoc(ODMHANDLE odmHandle, DWORD flags,
    LPSTR lpszDocId, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSaveDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
    LPSTR lpszNewDocId);

ODMSTATUS WINAPI ODMCloseDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
    DWORD activeTime, DWORD pagesPrinted, LPVOID sessionData, WORD dataLen);

ODMSTATUS WINAPI ODMNewDoc(ODMHANDLE odmHandle, LPSTR lpszDocId,
    DWORD dwFlags, LPSTR lpszFormat, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSaveAs(ODMHANDLE odmHandle, LPSTR lpszDocId,
    LPSTR lpszNewDocId, LPSTR lpszFormat, ODMSAVEASCALLBACK pcbCallBack,
    LPVOID pInstanceData);

ODMSTATUS WINAPI ODMActivate(ODMHANDLE odmHandle, WORD action,
    LPSTR lpszDocId);

ODMSTATUS WINAPI ODMGetDocInfo(ODMHANDLE odmHandle, LPSTR lpszDocId,
    WORD item, LPSTR lpszData, WORD dataLen);

ODMSTATUS WINAPI ODMSetDocInfo(ODMHANDLE odmHandle, LPSTR lpszDocId,
    WORD item, LPSTR lpszData);

ODMSTATUS WINAPI ODMGetDMSInfo(ODMHANDLE odmHandle, LPSTR lpszDmsId,
    LPWORD pwVerNo, LPDWORD pdwExtensions);

// QUERY ENHANCEMENTS

WORD WINAPI ODMGetDMSCount();

WORD WINAPI ODMGetDMSList( LPSTR buffer, WORD buffer_size );

ODMSTATUS WINAPI ODMGetDMS( LPCSTR lpszAppId, LPSTR lpszDMSId );

ODMSTATUS WINAPI ODMSetDMS( LPCSTR lpszAppId, LPCSTR lpszDMSId );

ODMSTATUS WINAPI ODMQueryExecute(ODMHANDLE odmHandle, LPCSTR lpszQuery,
                                 DWORD flags, LPCSTR lpszDMSList, LPSTR queryId );

ODMSTATUS WINAPI ODMQueryGetResults(ODMHANDLE odmHandle, LPCSTR queryId,
                                    LPSTR lpszDocId, LPSTR lpszDocName, WORD docNameLen,
                                    WORD *docCount );

ODMSTATUS WINAPI ODMQueryClose(ODMHANDLE odmHandle, LPCSTR queryId );

// ODMA 2.0 ENHANCEMENTS

ODMSTATUS WINAPI ODMCloseDocEx(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, DWORD activeTime, DWORD pagesPrinted,
                            LPVOID sessionData, WORD dataLen);

ODMSTATUS WINAPI ODMSaveAsEx(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPSTR lpszNewDocId, LPSTR lpszFormat, ODMSAVEASCALLBACK pcbCallBack,
                            LPVOID pInstanceData, LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMSaveDocEx(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPSTR lpszNewDocId,	LPDWORD pdwFlags);

ODMSTATUS WINAPI ODMSelectDocEx(ODMHANDLE odmHandle, LPSTR lpszDocIds,
                            LPWORD pwDocIdsLen, LPWORD pwDocCount, LPDWORD pdwFlags,
                            LPSTR lpszFormatFilter);

ODMSTATUS WINAPI ODMQueryCapability(ODMHANDLE odmHandle, LPCSTR lpszDmsId,
                            DWORD function, DWORD item, DWORD flags);

ODMSTATUS WINAPI ODMSetDocEvent(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            DWORD flags, DWORD event, LPVOID lpData, DWORD dwDataLen,
                            LPSTR lpszComment);

ODMSTATUS WINAPI ODMGetAlternateContent(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszFormat, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMSetAlternateContent(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszFormat, LPSTR lpszDocLocation);

ODMSTATUS WINAPI ODMGetDocRelation(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszLinkedId, LPSTR lpszFormat,
                            LPSTR lpszPreviousId);

ODMSTATUS WINAPI ODMSetDocRelation(ODMHANDLE odmHandle, LPSTR lpszDocId,
                            LPDWORD pdwFlags, LPSTR lpszLinkedId, LPSTR lpszFormat,
                            LPSTR lpszPreviousId);

#endif  // DEFERRED DECLARATIONS


#ifdef __cplusplus
}
#endif


/* 0.11 2006-11-25-20:26 Review and adjust for use as part of the 0.20alpha
        OdmNative100 distribution.

   0.10 2006-11-23-18:56 Make HWND parameter to ODMRegisterApp, reflecting
        the Win32 case.

   0.09 2006-11-23-15:00 Correct recommendation for view-case ambiguity
        in the description of ODMSelectDoc.

   0.08 2006-11-22-23:38 Correct indirection in the prototype for
        ODMSelectDoc.

   0.07 2006-11-22-20:07 Complete the annotation of ODMSelectDoc.

   0.06 2006-11-22-18:53 Remove the use of fixed-size char arrays in the
        prototypes.  This doesn't work for LPSTR.

   0.05 2006-11-22-18:19 Switch from Odma.h to dependence on the matching
        Odma32types100.h for Types and Values declarations.

   0.04 2006-11-21-15:47 Change to Odma32api100.h, add an updated copyright
        and license notice, then annotate the entry points that we are
        testing so far.

   0.03 2006-11-02-19:39 Add pfnODMSELECTDOC prototype.

   0.02 2006-11-02-16:12 Use LPCSTR for the AppId string pointer in
        the pfnODMREGISTERAPP prototype.

   0.01 2006-11-01-17:30 Correct type of ODMHANDLE output parameter of
        the ODMRegisterApp entry-point pointer type.

   0.00 2006-11-01-15:23 Define enough cases to confirm default
        DMS Connection.  Put WINAPI decorator inside with the pointer.
        */

#endif // !ODMA32API100_H
/*   $Header: /ODMdev/info/odma/OdmNative100/Odma32api100.h 13    06-11-25 20:28 Orcmid $
   */

/*                       *** end of Odma32api100.h ***                */
