/*
 * Decompiled with CFR 0.152.
 */
package info.odma.odmjni100;

import info.odma.odmjni100.OdmJniBind;
import info.odma.odmjni100.OdmJniPend;
import info.odma.odmjni100.OdmJniView;
import info.odma.odmjni100.OdmJniWork;
import info.odma.practical100.OdmConnection;
import info.odma.practical100.OdmError;
import info.odma.practical100.OdmFormat;
import info.odma.practical100.OdmNullConnection;
import info.odma.practical100.OdmPendingDocument;
import info.odma.practical100.OdmWorkingDocument;

class OdmJniApp
extends OdmNullConnection
implements OdmConnection {
    private long rIodmNative;
    private boolean knowConnection;
    private boolean knownConnection;
    private boolean knowDefaultDMS;
    private boolean knownDefaultDMS;

    private static native boolean checkViewOnly(long var0);

    private static native boolean hasConMan(long var0);

    private static native boolean hasDefaultDMS(long var0);

    private static native long jniNewDoc(long var0, String var2);

    private static native long selectDoc(long var0);

    private static native long jniKnownDocument(long var0, String var2);

    OdmJniApp(String string, long l) throws OdmError {
        super(string);
        this.rIodmNative = OdmJniBind.holdNativeInterface(OdmJniBind.getInterfaceRef(l));
        this.knowConnection = false;
        this.knownConnection = false;
        this.knowDefaultDMS = false;
        this.knownDefaultDMS = false;
    }

    public String interfaceImplementation() {
        return "ODMJNI 1.0 OdmJniApp 0.12";
    }

    public boolean available() {
        if (!this.knowConnection) {
            this.knowConnection = true;
            this.knownConnection = this.rIodmNative == 0L ? false : OdmJniApp.hasConMan(this.rIodmNative);
        }
        return this.knownConnection;
    }

    public void release() {
        if (this.rIodmNative != 0L) {
            OdmJniBind.freeNativeInterface(this.rIodmNative);
        }
        this.rIodmNative = 0L;
        this.knownConnection = false;
        this.knownDefaultDMS = false;
        super.release();
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public boolean dmsDefaultAvailable() {
        if (!this.knowDefaultDMS) {
            this.knowDefaultDMS = true;
            this.knownDefaultDMS = !this.available() ? false : OdmJniApp.hasDefaultDMS(this.rIodmNative);
        }
        return this.knownDefaultDMS;
    }

    public OdmPendingDocument acceptNewDocument(String string) throws OdmError {
        if (!OdmFormat.wfDocFormatName(string)) {
            throw new OdmError("Ill-formed acceptNewDocument docFormatName parameter: " + this.interfaceImplementation());
        }
        if (!this.dmsDefaultAvailable()) {
            return super.acceptNewDocument(string);
        }
        long l = OdmJniApp.jniNewDoc(this.rIodmNative, string);
        int n = OdmJniBind.getInterfaceStatus(l);
        if (l == 0L || n > 0) {
            switch (n) {
                case 2: {
                    return this.nullDocument.pendingCancelled();
                }
                case 6: {
                    return this.nullDocument.pendingLocalOperation();
                }
            }
            return this.nullDocument.pendingFailed();
        }
        OdmJniPend odmJniPend = null;
        try {
            odmJniPend = new OdmJniPend(l, this.nullDocument);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OdmJniBind.freeNativeInterface(l);
        if (odmJniPend == null) {
            return this.nullDocument.pendingFailed();
        }
        return odmJniPend;
    }

    public OdmWorkingDocument chooseDocument() {
        if (!this.dmsDefaultAvailable()) {
            return super.chooseDocument();
        }
        long l = OdmJniApp.selectDoc(this.rIodmNative);
        int n = OdmJniBind.getInterfaceStatus(l);
        if (l == 0L || n > 0) {
            switch (n) {
                case 2: {
                    return this.nullDocument.workingCancelled();
                }
                case 6: {
                    return this.nullDocument.workingLocalOperation();
                }
            }
            return this.nullDocument.workingFailed();
        }
        OdmJniView odmJniView = null;
        try {
            odmJniView = OdmJniApp.checkViewOnly(l) ? new OdmJniView(l, this.nullDocument) : new OdmJniWork(l, this.nullDocument);
        }
        catch (Throwable throwable) {
            odmJniView = null;
        }
        OdmJniBind.freeNativeInterface(l);
        if (odmJniView == null) {
            return this.nullDocument.workingFailed();
        }
        return odmJniView;
    }

    public OdmWorkingDocument openKnownDocument(String string) {
        if (!OdmFormat.wfDocId(string)) {
            throw new OdmError("Ill-formed openKnownDocument docId parameter: " + this.interfaceImplementation());
        }
        if (!this.dmsDefaultAvailable()) {
            return super.openKnownDocument(string);
        }
        long l = OdmJniApp.jniKnownDocument(this.rIodmNative, string);
        int n = OdmJniBind.getInterfaceStatus(l);
        if (l == 0L || n > 0) {
            return this.nullDocument.workingFailed();
        }
        OdmJniView odmJniView = null;
        try {
            odmJniView = OdmJniApp.checkViewOnly(l) ? new OdmJniView(l, this.nullDocument) : new OdmJniWork(l, this.nullDocument);
        }
        catch (Throwable throwable) {
            odmJniView = null;
        }
        OdmJniBind.freeNativeInterface(l);
        if (odmJniView == null) {
            return this.nullDocument.workingFailed();
        }
        return odmJniView;
    }

    static {
        System.loadLibrary("odmjni100");
    }
}

