/*
 * Decompiled with CFR 0.152.
 */
package info.odma.odmjni100;

import info.odma.odmjni100.OdmJniBind;
import info.odma.odmjni100.OdmJniWork;
import info.odma.practical100.OdmError;
import info.odma.practical100.OdmNull;
import info.odma.practical100.OdmNullPendingDocument;
import info.odma.practical100.OdmPendingDocument;
import info.odma.practical100.OdmWorkingDocument;

class OdmJniPend
extends OdmNullPendingDocument
implements OdmPendingDocument {
    final OdmNull nullDocument;
    long rNativePending;
    boolean isAvailable;
    private boolean isDmsAvailable;
    private boolean isOperationSucceeded;
    private boolean knowDocLocation;
    private String ourDocLocation;

    OdmJniPend(long l, OdmNull odmNull) {
        super(0);
        this.nullDocument = odmNull;
        this.rNativePending = OdmJniBind.holdNativeInterface(l);
        this.isAvailable = true;
        this.isDmsAvailable = true;
        this.isOperationSucceeded = true;
    }

    public String interfaceImplementation() {
        return "ODMJNI 1.0 OdmJniPend 0.01 OdmPendingDocument";
    }

    public boolean available() {
        return this.isAvailable;
    }

    public void release() {
        this.isAvailable = false;
        this.isDmsAvailable = false;
        this.isOperationSucceeded = false;
        OdmJniBind.freeNativeInterface(this.rNativePending);
        this.rNativePending = 0L;
        super.release();
    }

    public void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public boolean dmsAvailable() {
        return this.isDmsAvailable;
    }

    public boolean operationSucceeded() {
        return this.isOperationSucceeded;
    }

    public String docSubmissionLocation() {
        if (!this.knowDocLocation) {
            this.knowDocLocation = true;
            this.ourDocLocation = this.rNativePending == 0L ? null : OdmJniPend.jniPendLoc(this.rNativePending);
        }
        return this.ourDocLocation;
    }

    private static native String jniPendLoc(long var0);

    public OdmWorkingDocument commitContent() throws OdmError {
        if (this.rNativePending == 0L) {
            throw new OdmError("Invalid commitContent: " + this.interfaceImplementation());
        }
        long l = OdmJniPend.jniCommitContent(this.rNativePending);
        int n = OdmJniBind.getInterfaceStatus(l);
        if (l == 0L || n > 0) {
            return this.nullDocument.workingFailed();
        }
        this.release();
        OdmJniWork odmJniWork = null;
        try {
            odmJniWork = new OdmJniWork(l, this.nullDocument);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OdmJniBind.freeNativeInterface(l);
        if (odmJniWork == null) {
            return this.nullDocument.workingFailed();
        }
        return odmJniWork;
    }

    private static native long jniCommitContent(long var0);

    static {
        System.loadLibrary("odmjni100");
    }
}

