@echo off
rem OdmPSDK.bat 0.02                   UTF-8                  dh:2006-11-06
ECHO OdmPSDK.bat 0.02
rem
rem     This script requires the Microsoft Platform Software Development
rem     Kit (PSDK).  It operates in addition to OdmVC++, which it relies on.
rem     on.
rem
rem   **** REVIEW THE FOLLOWING COMMAND AND REVISE IT TO MATCH YOUR
rem   ****     PLATFORM SDK CONFIGURATION.  Always make a backup of your
rem   ****     modified script in case this one is over-written by install
rem   ****     of further OdmNative code releases.

SET OdmPSDK=%ProgramFiles%\Microsoft Platform SDK for Windows Server 2003 R2

rem   **** THERE ARE NO OTHER MODIFICATIONS NECESSARY BELOW HERE.

rem   **** THIS SCRIPT HAS ONLY BEEN TESTED WITH THE PSDK IDENTIFIED ABOVE.
rem     If there are difficulties with different Platform SDKs, it will be
rem     necessary to determine where that PSDK provides an environment-
rem     setting script and then make appropriate adjustments.

rem   ESTABLISH VC++ ENVIRONMENT FIRST.
rem     The separate VC++ settings are required first.  It is also
rem     important in case that is already integrated with a current PSDK.

IF NOT EXIST OdmVC++.bat GOTO :FAIL0
CALL OdmVC++

IF ERRORLEVEL 2 GOTO :FAIL1
IF "%VCINSTALLDIR%"=="" GOTO :FAIL1

IF NOT "%MSSdk%"=="" GOTO :HavePSDK

IF NOT EXIST "%OdmPSDK%\setenv.cmd" GOTO :FAIL2
CALL "%OdmPSDK%\setenv.cmd" /2000 /RETAIL
IF "%MSSdk%"=="" GOTO :FAIL3
IF ERRORLEVEL 2 GOTO :FAIL3

:HavePSDK
ECHO Using %MSSdk%
ECHO:
ECHO:  **** VISUAL C++ AND MICROSOFT PSDK COMMAND-LINE ENVIRONMENT SET UP
ECHO:  ****   OdmNative development is for %OS% %APPVER% and later.
ECHO:  ****   (NT 5.0 is Windows 2000).  OdmNative code is for %CPU%
ECHO:  ****   and compatible processors.
ECHO:
EXIT /B 0


:FAIL0
ECHO:
ECHO:  **** THE OdmPSDK.bat SCRIPT MUST BE EXECUTED IN THE SAME DIRECTORY
ECHO:  ****   AS OdmVC++.bat.  Please verify that both files are present
ECHO:  ****   and execute OdmPSDK from that directory.
ECHO:
EXIT /B 2

:FAIL1
ECHO:
ECHO:  **** THIS OdmPSDK.bat SCRIPT REQUIRES Visual C++ TO BE INSTALLED AND
ECHO:  ****   USABLE FOR COMMAND-LINE COMPILATION.  The OdmVC++ script
ECHO:  ****   has failed.  Please troubleshoot that script.
EXIT /B 2

:FAIL2
ECHO:  **** THE PSDK SCRIPT FOR SETTING COMMAND-LINE ENVIRONMENTS HAS NOT
ECHO:  ****   BEEN FOUND.  The file setenv.cmd is not in the expected
ECHO:  ****   location.  Please verify that variable OdmPSDK setting
ECHO:  ****   %OdmPSDK%
ECHO:  ****   is correct.
ECHO:

:FAIL3
ECHO:  **** THE PLATFORM SDK COMMAND-LINE ENVIRONMENT IS NOT SET UP.
ECHO:  ****   This script may not be compatible with the installed PSDK.
ECHO:  ****   Please ensure that a PSDK is installed and adjust
ECHO:  ****   this OdmPSDK script to operate with it.
ECHO:
EXIT /B 2

rem -----1---------2---------3---------4---------5---------6---------7----*

rem SET ENVIRONMENT TO USE MICROSOFT PSDK.  This script can be executed
rem in a batch session to set the environment for performing a VC++ 2005
rem console project using the Microsoft Platform SDK.

rem 0.02 2006-11-06-14:18 Rename and harden the procedure to use ERRORLEVEL
rem      and report on failures.
rem 0.01 2006-10-31-15:49 Work properly for PSDK Windows Server 2003 R2.
rem 0.00 2006-10-31-14:39 Create version to connect PSDK for Visual C++
rem      2005 Express Edition in confirming native Windows compiling for
rem      the ODMJNI project OdmNative code development.

rem $Header: /MyProjects/java/ODMdev/info/odma/OdmNative100/OdmPSDK.bat 2     06-11-06 14:18 Orcmid $
rem                     *** end of OdmPSDK.bat ***
