@echo off
rem OdmVC++.bat 0.27                   UTF-8                  dh:2006-11-04
echo:
echo OdmVC++.bat 0.27: %USERNAME%'s %COMPUTERNAME% Command-Line VC++ for ODMJNI

SET ERRORLEVEL=
rem     Remove any incoming ERRORLEVEL setting.

IF "%VS80COMNTOOLS%"=="" GOTO :FAIL1
IF NOT "%VCINSTALLDIR%"=="" GOTO :PRESET
IF NOT EXIST "%VS80COMNTOOLS%vsvars32.bat" GOTO :FAIL2
ECHO Settings from %VS80COMNTOOLS%

CALL "%VS80COMNTOOLS%vsvars32.bat"
rem       using the vsvars setup for the installed Visual Studio 2005.

IF "%ERRORLEVEL%" == "" SET ERRORLEVEL=1
EXIT /B %ERRORLEVEL%

:PRESET
ECHO Using VC++ at %VCINSTALLDIR%
rem      the vsvars have already been set.

EXIT /B 1

:FAIL1
ECHO:  **** This script requires Visual C++ 2005 to be installed and.
ECHO:  **** the environment variable VS80COMNTOOLS set as part of that
ECHO:  **** Visual C++ or Visual Studio 2005 install
EXIT /B 2

:FAIL2
ECHO: **** Although VS80COMNTOOLS is set, the file vsvars32.bat is
ECHO: **** not available at %VS80COMNTOOLS%
ECHO: ****    Install Visual C++ 2005 Express Edition or modify this
ECHO: **** MyVC++.bat script to locate vsvars32.bat properly in your
ECHO: **** Visual Studio 2005 configuration.
EXIT /B 2

rem -----1---------2---------3---------4---------5---------6---------7----*

rem SET ENVIRONMENT TO USE VC++ 2005.  This script can be executed
rem in a batch session to set the environment for performing a VC++ 2005
rem console project.  To be saved as OdmVC++.bat wherever you want to work
rem with the Visual C++ 2005 command-line compiler for ODMJNI work.

rem This script assumes that VC++ 2005 is installed.  The VC++ 2005
rem Express Edition is sufficient.  The installation of Visual Studio
rem or VC++ will set the VS80CMNTOOLS environment variable, which
rem is used to locate the vsvars32.bat environment-setup script.

rem The procedure always exits with ERRORLEVEL set, with 1 for success,
rem 2 for failure.

rem 0.27 2006-11-04-16:35 Change name from MyVC++ to OdmVC++ to be
rem      consistent with other nomenclature for the ODMJNI project.
rem 0.26 2006-11-04-15:31 The script is tightened to confirm that vsvars
rem      exists where we are looking for it.  ERRORLEVEL is always set.
rem 0.25 2006-10-29-19:45 Adjusted for use with the ODMJNI project and
rem      other projects to make simple use of the VC++ 2005 compiler.
rem      Checks for VS80COMNTOOLS being defined.
rem 0.20 2006-09-30 Instead of doing all of the settings, this version
rem      uses the vsvars32.bat that is installed to create the Visual
rem      Studio 2005 environment for VC++.
rem 0.10 2005-10-06-12:00 Version created for the Visual C++ Toolkit 2003,
rem      the first VC++ edition that was installed for experimental use
rem      and easy-to-recreate open-source projects.

rem $Header: /MyProjects/java/ODMdev/info/odma/OdmNative100/OdmVC++.bat 7     06-11-04 17:28 Orcmid $
rem                     *** end of OdmVC++.bat ***
