/* Setup00.c 0.03                    UTF-8                   dh:2006-11-13
 *
 *          IMPLEMENT THE NATIVE METHOD OF THE SETUP00 PROJECT
 *          **************************************************
 *
 * This is the simple implementation of the native method, based on that
 * given by Sheng Liang in section 2.2 of "The Java Native Interface:
 * Programmer's Guide and Specification."
 *
 * A major difference in this version is the use of direct Windows Console
 * output, with the output produced from a large constant string.  The
 * console is located dynamically without resort to Standard C libraries.
 * This makes for a slightly smaller DLL.
 *
 * We compile with static linking (option /MT) in order to simplify
 * deployment.  For ODMJNI, there will not be much use of the standard
 * libraries.  The dependencies will be more on native Windows functions.
 *
 * However, once we rely on functions in <stdio.h> and similar libraries,
 * there will be noticeable overhead for the libraries.  This is a concern
 * for logging functions.  For the most part, we want input-output done at
 * the Java level.
 *
 * There is still an open question on how to best provide logging functions
 * for exceptional odmjni100 events that may be important in troubleshooting
 * operation between application, the ODMA Connection Manager, and a DMS
 * integration.
 */


#include <jni.h>
#include <windows.h>

#include "Setup00.h"


/*              Setup00> */
#define INDENT "         "
#define STARS  "    **** "

static const char indent[] = INDENT;
static const char stars[] =  STARS;


static void hello(HANDLE *out)
{   /* Tell them who's here, using Windows Output.  Return an
       indication of whether or not we succeeded. */

    const char greeting[]
      = "\nSetup00> 0.03 Confirming JNI access to native Setup00.print()\n"
        INDENT "Program " __FILE__ " dated " __TIMESTAMP__ "\n"
        INDENT "Compiled at " __TIME__ " on " __DATE__
    #if defined(__cplusplus)
        " as C++"
    #elif defined(__STDC__)
        " as Standard C"
    #elif defined(_MSC_VER)
        " as Visual C"
    #else
        " as C Language"
    #endif
    #if defined(_MSC_EXTENSIONS)
        " extended"
    #endif
    #if defined(_DLL)
        " DLL"
    #endif
    #if defined(_WIN32)
        " (Win32)"
    #endif
        "\n\n";

    const DWORD greetingSize = sizeof(greeting)-1;
        /* Do not count the terminal null that C provides. */

    DWORD bytesWritten = 0;
        /* Amount of the output that was written */

    BOOL writeOK = FALSE;
        /* The return status.  We don't know what to do if it fails
           though. */

    writeOK = WriteFile(out, greeting, greetingSize,
                        &bytesWritten, NULL);
              /* See the PSDK Windows API Reference */

    /* XXX: We are not checking for any kind of failure here because
       there's nothing to do about it.  If we return a result from
       print() then there's a possibility.
       */

    } /* hello */


JNIEXPORT
    void JNICALL Java_Setup00_print(  JNIEnv *pIenv,
                                          /* JNI Environment interface */
                                      jobject pThisClass
                                          /* The Setup00 class */
                                      )

    {   /* Just perform simple output to show that it works. */

        HANDLE conout = GetStdHandle(STD_OUTPUT_HANDLE);
            /* Get the standard output handle for this process. */

        if (conout==NULL)
             {  /* There is no console associated with the current
                   process.  We must create one.
                   */
                AllocConsole();
                conout = GetStdHandle(STD_OUTPUT_HANDLE);
                };

        if (conout==NULL)
             return;
                /* Because we have failed to get an output console. */

        hello(conout);

        }  /* Java Setup00.print */


/* 0.03 2006-11-13-17:38 Change to using a constant and the Windows
        Console functions rather than use stdio.h.  This reduces the
        DLL to 49,152 bytes.

   0.02 2006-11-12-17:24 Modify a hello() function from OdmNative100
        TestSetup01.c 0.02 just to have something more exotic to present.
        The size of the resulting DLL is now different.

   0.01 2006-11-12-17:13 Substitute fputs for a modest decrease in size
        of the DLL from 57,344 to 53,248 bytes using static binding (option
        /MT).  Dynamic binding (option /MD) gets us down to 5,632 bytes,
        but then there are issues around finding the correct run-time
        library.  We will avoid that by using /MT and being careful about
        relying on the standard run-time.

   0.00 2006-11-11-23:19 Provide version of the Sheng Liang example to
        confirm with Setup00 implementation.

   $Header: /MyProjects/java/ODMdev/info/odma/odmjni100/test/setup00/Setup00.c 3     06-11-13 17:48 Orcmid $
   */

/*                           *** end of Setup00.c ***                   */
