/* Setup00.java 0.01                  UTF-8                  dh:2006-11-12
 *
 *      COMPILE THE BASIC HELLO-WORLD DEMONSTRATION OF JNI OPERATION
 *      ************************************************************
 *
 * This program is a derivative of Shen Liang's initial Hello World
 * JNI demonstration program, in Chapter 2 of "The Java Native Interface:
 * Programmer's Guide and Specification."
 *
 * This version is modeled on the Java application class in section 2.2.
 * An important difference is the use of a private static native method.
 * Almost all of the native methods used in ODMJNI are static, and I
 * want to verify the workability of that as part of this setup exercise.
 */

 class Setup00
 {  /* Make a simple class with a single native method. */

    private static native void print();
        /* The class-level native method */

    public static void main(String[] args)
    {   /* The main procedure */

        print();
            /* Use the static method to
               accomplish our purpose.
               */

        } /* main */

    static

        {   /* Static initialization of this class specifies the
               loading of the DLL that we'll use. */

            System.loadLibrary("Setup00");

            } /* static initialization */

    } /* Setup00 */


/* 0.01 2006-11-12-16:43 Make the desired version with a static native
        method, modeling the typical ODMJNI case.
   0.00 2006-11-11-22:51 Provide literal version of Liang's class
        declaration, with different name for our purposes.

   $Header: /MyProjects/java/ODMdev/info/odma/odmjni100/test/setup00/Setup00.java 2     06-11-12 16:47 Orcmid $
   */

/*                         *** end of Setup00.java ***                   */
