@echo off
rem BuildClass01.bat 0.01            UTF-8                    dh:2006-11-13
ECHO BuildClass01.bat 0.01 COMPILING Setup01.java FOR MASTER JNI TEST
ECHO:    This Set of native Java methods demonstrates the key cases that
ECHO:    are representative of all variations needed for odmjni100.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO:  **** BuildClass01.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST Setup01.java GOTO :FAIL1

SET ERRORLEVEL=
javac Setup01.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo: **** Setup01.class COMPILED ****
echo:
echo: There are no errors or warnings.  This program can be run
echo: via RunSetup01.bat after the Setup01.dll is also built
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO:  **** EXECUTE BuildClass01.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO:  ****   The OdmJava.bat script must be available two levels above.
ECHO:  ****   Verify your Setup01 configuration and ensure that the
ECHO:  ****   directory holding BuildClass01.bat is the current working
ECHO:  ****   directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO:  **** THE Setup01.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO:  ****   The file should be in the same directory as this BuildClass01
ECHO:  ****   script.  BuildClass01 has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo: **** ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo: To capture a log, run with redirection to a file or pipe the result
echo: of BuildClass01 into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA CLASS TO CONFIRM MASTER JNI CASES
rem The Java program built with this script is used to demonstrate that all
rem of the key cases for odmjni100 use of native methods are accomodated.
rem


rem 0.01 2006-11-13-19:44 Correct error handling of compiler errors.
rem 0.00 2006-11-12-22:16 customized from the odmjni100 BuildClass00.bat
rem      0.01.

rem $Header: /MyProjects/java/ODMdev/info/odma/odmjni100/test/setup01/BuildClass01.bat 5     06-11-13 21:12 Orcmid $

rem                     *** end of BuildClass01.bat ***