/* Setup01.cpp 0.06                  UTF-8                   dh:2006-11-27
 *
 *          IMPLEMENT THE NATIVE METHODS OF THE SETUP01 PROJECT
 *          ***************************************************
 *
 * This is the C++ Language implementation of the native-method DLL
 * for Setup01.  It is used to progressively confirm the different
 * cases of JNI that are supported in one form or another by the
 * odmjni100.dll.
 *
 * There are basically only a small number of cases that the different
 * native-method entries must deal with.  There are a small number of
 * input parameters and a small number of output results.  This DLL
 * implements methods that exercise the critical cases.
 */


#include <jni.h>
    /* For the standard JNI interface.  This interface will be the
       C++ version in the case of Setup01.cpp.
       */

#include <windows.h>
    /* For Windows API types and the Windows Console, WriteFile */

#include "Setup01x.h"
    /* Rely on the annotated cumulative-update header. */


JNIEXPORT
    jint JNICALL
         Java_Setup01_jniVersion(  JNIEnv *pIenv,
                                            /* JNI environment
                                               interface */
                                   jclass pThisClass
                                            /* not used */
                                   )

{   /* Return the JNI Version Number m.n, coded as 0x000m000n.
       pIenv is a ppv. That is, JNIEnv is a pv, and what's passed
       in is a ppv.
         Demonstration:

           1. Access to *pIenv interface methods via proper C++
              Language pointer to interface class.  These use a special
              hack involving inline methods to provide a portable solution
              that works regardless of the compiler's implementation of
              virtual methods.  This is a good platform-neutral approach.

           2. Return of jint result.
       */

    return pIenv->GetVersion();

    } /* jniVersion */


/* Some Auxilliary Definitions: */

    /*              Setup01> */
    #define INDENT "         "
    #define STARS  "    **** "

    static const char indent[] = INDENT;
    static const char stars[] =  STARS;


JNIEXPORT
    jstring JNICALL
        Java_Setup01_jniGreeting(  JNIEnv *pIenv,
                                            /* JNI environment
                                               interface. */
                                   jclass pThisClass
                                            /* not used */
                                   )

{   /* Return the internal constant string as a Java String to the
       caller.  This constant is suitable for printing to the
       console. */

    const char pszGreeting[]
      = "\nSetup01> 0.06 C++ DLL IMPLEMENTING MASTER NATIVE-METHOD CASES\n"
        INDENT "Program " __FILE__ " dated " __TIMESTAMP__ "\n"
        INDENT "Compiled at " __TIME__ " on " __DATE__ " as"
    #if defined(_MSC_EXTENSIONS)
        " MS-extended"
    #endif
    #if defined(__cplusplus)
        " C++"
    #elif defined(__STDC__)
        " Standard C"
    #elif defined(_MSC_VER)
        " Visual C"
    #else
        " C Language"
    #endif
    #if defined(_DLL)
        " DLL"
    #endif
    #if defined(_WIN32)
        " (Win32)"
    #endif
        "\n";

    return pIenv -> NewStringUTF(pszGreeting);
        /* The '\0' terminated ASCII greeting is accepted as UTF-8
           and a local reference to a Java String object is constructed.
           This String object is passed to the application (and the
           local reference is released).
             Demonstration:
               1. Use of C/C++ Language ASCII strings as the source of
             data to be delivered to the Java application.
               2. Construction of a local String object from an ASCII/UTF
             string.
               3. Return of a String object to the calling Java application.
           */

    }  /* jniGreeting */


JNIEXPORT
    jlong JNICALL
        Java_Setup01_jniAppId(  JNIEnv *pIenv,
                                         /* JNI Environment
                                            interface */
                                jclass pThisClass,
                                         /* Not used */
                                jstring jAppId
                                        /* The provided String */
                                )
{   /* We will convert the incoming string to a char[ ] with UTF8
       so we can output it via WriteFile to the Windows Console.
       The result we return is the address of the location where
       the converted string was stored until released.
       */

    const DWORD appIdSize = pIenv -> GetStringUTFLength(jAppId);
        /* The size we will need to pass to output.
           FIXME: We should check against jAppId being NULL */

    DWORD bytesWritten = 0;
        /* Amount of the output that was written */

    const char *pszAppId
        = pIenv -> GetStringUTFChars(jAppId, NULL);
            /* In C++, GetStringUTFChars returns a char * */

    BOOL writeOK = FALSE;
        /* The return status.  We don't know what to do if it fails
           though. */

    HANDLE out = GetStdHandle(STD_OUTPUT_HANDLE);
        /* Get the standard output handle for this process.
           (See the similar process in Setup00.)  */

    if (out==NULL)
         {  /* There is no console associated with the current
               process.  We must create one.
               */
            AllocConsole();
            out = GetStdHandle(STD_OUTPUT_HANDLE);
            };

    if (out != NULL)
         { writeOK = WriteFile(out, pszAppId, appIdSize,
                               &bytesWritten, NULL);
              /* See the PSDK Windows API Reference */
           }

    pIenv -> ReleaseStringUTFChars(jAppId, pszAppId);
        /* Again, in C++ the Release expects a const char * for pszAppId */

    return (jlong) pszAppId;

    } /* jniAppId */


JNIEXPORT
    jstring JNICALL
        Java_Setup01_jniNullString(  JNIEnv *pIenv,
                                              /* JNI Environment
                                                 interface */
                                     jclass pThisClass,
                                              /* Not used */
                                      jlong llBig
                                              /* Almost biggest value */
                                     )
{   /* This is a mostly-useless function just to demonstrate how to
       return a null String object (or any other object) from a
       native method implementation.
       */

    return NULL;

    } /* jniNullString */



/* 0.06 2006-11-27-18:39 Convert to C++ and adjust for the differences
        in the calling structure into pIenv that involves.  The DLL is
        still 49,152 bytes in size.

   0.05 2006-11-14-15:34 Add jniNullString and simply return a NULL to
        see that the obvious works.

   0.04 2006-11-13-23:54 Add jniAppId implementation to demonstrate
        use of the console from a converted String value, and return of
        a pointer in a jlong.

   0.03 2006-11-13-22:23 Modify the constant text to be more descriptive
        of what the Java-presented output is from.  There is no change in
        DLL size.

   0.02 2006-11-13-21:10 Implement jniGreeting().  This version demonstrates
        return of a java.lang.String as the result from a native method.
        The string is built from a length ASCII/UTF-8 constant based on
        one employed in Setup00 0.03.  This DLL is also 49,152 bytes.

   0.01 2006-11-13-00:06 Implement jniVersion().  This DLL is 49,152 bytes
        and there is no real explanation for it except that there must be
        a lot of padding held onto for some purpose.

   0.00 2006-11-12-23:37 Strip down Setup00.c 0.02 for filling in with
        the new native-method implementations in synchronization with
        Setup01.java progression.

   $Header: /ODMdev/info/odma/odmjni100/test/setup01/Setup01.cpp 9     06-11-27 19:44 Orcmid $
   */

/*                          *** end of Setup01.cpp ***                   */
