/*  PromptedIO: 0.12 Console-Prompted Data Input Operations (ALPHA) */
/*  $Header: /Java2/com/orcmid/io/alpha/PromptedIO.java 11    03-07-11 17:21 Orcmid $ */

            /* This material is valid for all java APIs since JDK 1.2.
               It is designed to be used by console applications.
               
               This file defines a class that provides operations for
               prompted entry and validation of data input values.
               
               WARNING: THIS IS ALPHA-LEVEL MATERIAL.  THE CLASSES AND
               INTERFACES ARE NOT VERSIONED.  THE MATERIAL IS SUBJECT
               TO CHANGE WITHOUT NOTICE.  THERE IS NO COMMITMENT TO 
               ADVANCE ALPHA MATERIALS TO PRODUCTION QUALITY OR TO A
               RELEASE VERSION.
               */

/*  INSTALLATION INSTRUCTIONS
    *************************
    
    1.  For alpha-test usage of these classes, place this file in a directory
        where alpha-level console interface classes have already been compiled.  
        
    2.  Compile this file.  Two class files will be produced:
    
            NoEntryInputException   Exception class for reporting when no 
                                    entry is provided for an input value
            PromptedIO              Class of operations for use in prompting
                                    and validating of data for an application.
            
    3.  The files are used for development of applications that take advantage
        of PromptedIO operations to ensure safe, confirmed input of required
        parameters and interactive data.
        
    4.  NOTE: These ALPHA-version classes are defined for use within a default package 
        only.  They cannot be imported, only used from applications that name the
        classes directly.  The application must be compiled into the same
        directory and executed from that directory.  
    */
    
    

/*  THE CONSOLE PROMPTED-INPUT CLASSES
    **********************************
    */
    
class NoPromptedEntryException extends java.lang.Exception
{/* It is desirable to allow the application to specify the exception it
    wants to catch when there is no entry provided in response to a prompt.
    Unfortunately, this makes unambiguous catching of exceptions problematic
    because the application must also catch every java.io.IOException and
    java.lang.RuntimeException that arises during a checked prompted-entry
    method, if the specified exception can be any java.lang.Exception.  
       As a compromise, we allow the application to create and provide
    any NoPromptedEntryException instance to be thrown back to it.  If
    null is provided, a default NoPromptedEntryException will be thrown.
       We haven't addressed the case of requiring an entry no matter what.
    0.07: The current thinking is that we won't require mandatory entries
    in PromptedIO.  That is definitely an application must handle.
    */
    public NoPromptedEntryException()
    {   super();
            /* The blank case simply works */
        }
        
    public NoPromptedEntryException(String msg)
    {   super(msg);
            /* 0.07 We also allow the simple message case */
        }
        
    } // class NoPromptedEntryException


class PromptedIO
{/* 0.12 2003-07-11-17:17 Correct exception objects to identify this version.
    0.11 2003-06-26-02:39 Correct omitted indentation in describeDouble too.
    0.10 2003-06-25-00:10 Correct omitted indentation in describeInteger
    0.09 2003-06-24-23:23 Added in the promptedInteger methods.
    0.08 2003-06-24-22:34 Do a clean-up pass that has basic items cleaned-up
         and has the signatures be the ones I want to perpetuate for other
         methods.
    0.07 2003-06-24-00:45 I am losing my grip on the package and need to
         go through and tighten up some things.  Before I clone the methods,
         I want a decent factoring of everything.
    0.06 2003-06-23-18:12 Refactor enough more to provide for command-line
         parameter processing and other processing of input fields not
         directly from a prompted console entry.
    0.05 2003-06-21-12:36 Confirm construction from a separate file
         for compilation with (default) package accessibility.
    0.04 2003-06-21-08:22 Begin refactoring so that the validation methods
         can be used for other strings, with optional reporting of problems
         done as well, as when accepting input from a command line or a
         similar non-interactive source.
    0.03 2003-06-20-22:13 Tighten NaN tolerance and add better explanation
         of accepted input ranges.  Other tolerance cases are not implemented
         yet.
    0.02 2003-06-20-20:53 Complete handling of exceptions for no entry.
    0.01 2003-06-20-14:16 Initial modification of earlier version to use
         the console input-output framework and confirm compilation using
         separate files.  The tolerance provisions are not implemented.
    */
    
    
    /*  ESSENTIAL FIELDS 
        ****************
        These are key private fields that are global in an instance and global
        in the class anytime this version is being used.
        */
    
    private static final NoPromptedEntryException
            defaultNoEntryException 
                = new NoPromptedEntryException
                    ("PromptedIO 0.12-ALPHA No entry in response to prompt");
                        // the default thrown for no-entry cases.
                    
    private static final java.lang.IllegalArgumentException
            internalValidationException 
                = new java.lang.IllegalArgumentException
                    ("PromptedIO 0.12-ALPHA WILD THROW: INTERNAL ERROR");
                        // an exception used internally only.
                        
    private static final java.lang.NullPointerException
            nullInterfaceException
                = new java.lang.NullPointerException
                    ("PromptedIO 0.12-ALPHA null interface parameter");
                        // an exception used to fail constructors and methods.
                
                       
    private final IConOut stdout;       
            //  line-oriented console output used throughout an instance.
     
    private final IConLineIn stdin;     // line-oriented console input
            /*  IOExceptions from stdin methods are not caught. */

            
    /*  THE CONSTRUCTORS
        ****************
        There are three basic constructions used for this class.  They 
        all establish operation with console input-output components.
        The versions of these interfaces are from package companions at
        this point.  Under normal conditions it will always be that way.
        */
        
    public PromptedIO(IConOut out, IConLineIn in)
                            throws java.lang.NullPointerException
    {   /*  Use separately-provided IConOut and IConLineIn streams 
            as if externally-coupled for interactive operation.
            */
        stdout = out; 
        stdin = in;
        if (out == null || in == null) 
             throw nullInterfaceException;
        }
      
    public PromptedIO(IConLineIO conIO)
                            throws java.lang.NullPointerException
    {   /*  using IConLineIO for both input and output. */
        if (conIO == null) 
             throw nullInterfaceException;
        stdout = conIO;     // using conIO's IConOut interface
        stdin = conIO;      // using conIO's IConLineIn interface
        }
        
    public PromptedIO()
    {   /*  using the default console when no interfaces are provided */
        stdout = new ConLineIO();
        stdin = (IConLineIn) stdout;  
        }
        
        
    /*  COMMON INTERNAL PROCEDURES 
        **************************
        Private functions that are used in support of typical operations,
        mostly having to do with error handling and exception creation.
        */
        
    private static final String emptyString = "";
        /* used in place of null in conversions of strings */
        
        
    private static String cleanedText(String entry,
                                      NoPromptedEntryException noEntryEx)
                          throws NoPromptedEntryException
                          
    {   /* Make sure there is an entry in the given text and if not,
           throw ourselves out the NoPromptEntry case. */
        if (entry == null) 
             entry = emptyString;

        if (entry.length() != 0) 
             return entry;
         
        throw ( noEntryEx != null ? noEntryEx
                                  : defaultNoEntryException );
        } // cleanedText
        
        
    private String cleanedPrompt( String prompt, 
                                  String indent,
                                  NoPromptedEntryException noEntryEx)
                  throws java.io.IOException,
                         NoPromptedEntryException 
    {/* Produce the prompt and deliver a cleaned input string
        or else bail out. 
        */
                
        stdout.println();
        stdout.print(indent+prompt);
        stdout.flush();
        
        return cleanedText( stdin.readLine(), 
                            noEntryEx);
    } // cleanedPrompt
    
        
    private static final String 
            badValueMsg = "PromptedIO 0.12 Unacceptable value ";
    
    private static java.lang.IllegalArgumentException
    
                rejectValue( String value,
                             java.lang.IllegalArgumentException rejection)
                       
    {   /* return the given exception or else make one up that provides
           the invalid value.
           */
        
        return ( rejection != null ? rejection
                : new java.lang.IllegalArgumentException
                                        (badValueMsg + value) ) ;
                                        
        } // rejectValue
        
        
    private static java.lang.IllegalArgumentException
    
                rejectDouble( double value,
                              java.lang.IllegalArgumentException rejection)

    {   /* convert to double value format */
        return rejectValue(java.lang.Double.toString(value),
                           rejection);
        } // rejectDouble
    
    
    private static java.lang.IllegalArgumentException
    
                rejectInteger( int value,
                               java.lang.IllegalArgumentException rejection)

    {   /* convert to double value format */
        return rejectValue(java.lang.Integer.toString(value),
                           rejection);
        } // rejectInteger
    
    
    
    private static final String 
            badFormMsg = "PromptedIO 0.12: Unacceptable format ";
            
    private static final String
            badEmpty = "PromptedIO 0.12: Unacceptable empty string: \"\"";
            
    private static final String
            badNull = "PromptedIO 0.12: Unacceptable null string reference";
    
    private static java.lang.IllegalArgumentException
                rejectText( String s,
                            java.lang.IllegalArgumentException rejection)

    {   /* return the given exception or supply one that shows the
           literal form of the offending data string
           */
        
        return ( rejection != null ? rejection
                : new java.lang.IllegalArgumentException
                  ( s == null ? badNull
                              : s == "" ? badEmpty
                                        : badFormMsg + '"'+ s +'"' ) );
        } // rejectText
        

    /*  DOUBLE VALUE INPUT METHODS 
        **************************
        */
        
    public static double parsedDouble
            (   String text,    
                java.lang.IllegalArgumentException rejection)
            throws java.lang.IllegalArgumentException
    {   /*  0.08 utility operation for tossing unacceptable double
            forms and returning the successfully-parsed doubles.
            */
        try 
        {   return java.lang.Double.parseDouble
                            (text == null ? emptyString : text);
                            // 
            }
        catch (NumberFormatException n)
        {   throw rejectText(text, rejection);
            }
            
        } // parsedDouble filter
        
        
    public double promptedDouble
            (   String prompt,
                        // the text of the prompt
                String indent,
                        // the prefix on every line of output
                NoPromptedEntryException noEntryEx
                )
            throws java.io.IOException, NoPromptedEntryException                    
    {   /*  promptedDouble() version that uses default min, max, 
            and tolerance values.
            */
        return promptedDouble(prompt, indent, noEntryEx,
                              -java.lang.Double.MAX_VALUE,
                              +java.lang.Double.MAX_VALUE,
                              0.0d );
        } // .promptedDouble (exception default)
        
        
    public double promptedDouble
             ( String prompt,
                        /* the text for inviting input */
               String indent,
                        /* the prefix on every line of output */
               NoPromptedEntryException noEntryException,
                        /* thrown if there is no entry, defaulted if null */
               double min,
                        /* the least acceptable value in the range */
               double max,
                        /* the maximum acceptable value in the range */
               double tolerance
                        /* a parameter for controlling the tolerance at 0 
                           Double.Nan means that Nan plus all values in
                           the specified range are tolerated. */
               )
            throws java.io.IOException, 
                   NoPromptedEntryException
                /* There is nothing to be done about IOExceptions.
                   The noPromptedEntryException is the easiest we could 
                   come up with for applications to catch easily without
                   confusion.
                   */
                   
    {/* .promptedDouble() prompts for input until an acceptable value 
        is entered or no entry is provided (e.g., the operator just 
        presses ENTER).
        */
        if (prompt == null)
            prompt = emptyString;
        if (indent == null)
            indent = emptyString;

        while (true)
        {   /* prompt for the input until we return with a result */
            
            String text = cleanedPrompt(prompt, indent, noEntryException);
                   /* can throw IOException and NoPromptedEntryException
                      */
            try
            {   return diagnosedDouble(text,
                                       stdout,
                                       indent + "unacceptable entry: ",
                                       indent,
                                       internalValidationException,
                                       min, max, tolerance);

                } // try
                
            catch (java.lang.IllegalArgumentException a)
            {   /* We have diagnosed an unacceptable format or range
                   and we drop through to take another shot at it. */
                stdout.println(indent + 
                           "To make no entry, press ENTER.");
                } // catch internalValidationException

            } // while still needing a correct entry
            
        } // .promptedDouble (exception)
        
    
public double promptedDouble
            (   String prompt,
                        // the text of the prompt
                String indent
                        // the prefix on every line of output
                )
            throws java.io.IOException                  
    {   /*  promptedDouble() version that uses default min, max, 
            tolerance, and noEntry values.
            */
        return promptedDouble(prompt, indent,
                              java.lang.Double.NaN,
                              -java.lang.Double.MAX_VALUE,
                              +java.lang.Double.MAX_VALUE,
                              0.0d );
        } // .promptedDouble() with no surprise values and NaN no-entry
        
        
    public double promptedDouble
             ( String prompt,
                        /* the text for inviting input */
               String indent,
                        /* the prefix on every line of output */
               double noEntry,
                        /* returned if there is no entry */
               double min,
                        /* the least acceptable value in the range */
               double max,
                        /* the maximum acceptable value in the range */
               double tolerance
                        /* a parameter for controlling the tolerance at 0 
                           Double.Nan means that Nan plus all values in
                           the specified range are tolerated. */
               )
            throws java.io.IOException
                /* There is nothing to be done about IOExceptions.
                   */
                   
    {/* .promptedDouble() prompts for input until an acceptable value 
        is entered or no entry is provided (e.g., the operator just 
        presses ENTER).
        */
        try
        {   return promptedDouble(prompt, indent,
                                  defaultNoEntryException,
                                  min, max, tolerance);
            }
        catch (NoPromptedEntryException x)
        {   return noEntry;
            }
        
        } // .promptedDouble(noEntry)

        
    public static double diagnosedDouble
            (   String text,
                    // the value to be converted and verified
               IConOut stdout, 
                    // console for presenting any diagnostics
                String caption,
                    // the caption used if the entry is rejected
                    // null to suppress presentation of a caption
                String indent,
                    // indentation used on all non-caption lines
                java.lang.IllegalArgumentException rejection,
                double min,
                double max,
                double tolerance
                )
            throws java.lang.IllegalArgumentException,
                   java.lang.NullPointerException
    {   /* Validate the given text as a double */
        if (stdout == null)
             throw nullInterfaceException;
         
        double value;
        
        try
        {   value = parsedDouble(text, internalValidationException);
            }
        catch (IllegalArgumentException ex)
        {   /* Generate the invalid format case for the input. */

            describeDouble(stdout, 
                           ( caption == null ? null
                                             : caption + '"'+text+'"' ),
                           indent, min, max, tolerance);
                           
            throw rejectText(text, rejection);   
            }
                
        return diagnosedDouble(value, 
                               stdout, caption, indent,
                               rejection, min, max, tolerance);

        } // diagnosedDouble(text)

        
    public static double diagnosedDouble
            (   double value,
                    // the value to be converted and verified
               IConOut stdout, 
                    // console for presenting any diagnostics
                String caption,
                    // the caption used if the entry is rejected
                    // null to suppress presentation of a caption
                String indent,
                    // indentation used on all non-caption lines
                java.lang.IllegalArgumentException rejection,
                double min,
                double max,
                double tolerance
                )
            throws java.lang.NullPointerException,
                   java.lang.IllegalArgumentException
                   
    {   /* Diagnose a double value for validity against the parameters. */
        
        if (stdout == null)
             throw nullInterfaceException;
         
        try
            {   return validatedDouble(value,
                                       internalValidationException,
                                       min, max, tolerance);
                /* throwing IllegalArgumentException for a range failure. */
                } // try
            
            catch (java.lang.IllegalArgumentException a)
            {   /* We have an unacceptable range or special-value
                   case and we drop through to have it explained. */
                } // catch IllegalArgumentException

            /*  Describe the format and range that works 
                along with any captioned value report */

            describeDouble(stdout, 
                           ( caption == null ? null
                                             : caption + value ),
                           indent, 
                           min, max, tolerance);
                           
            throw rejectDouble(value, rejection);
            
        } // diagnosedDouble(double)

        
    static public void describeDouble
            (   IConOut stdout,     // output destination
                 String caption,    // optional unindented caption
                 String indent,     // indentation on description lines
                 double min,        // parameters of the required text.
                 double max,
                 double tolerance )
            throws NullPointerException
    {   /*  Provide a static description (on any console) of the acceptable
            input according to the specified min, max, and tolerance values.
            Assume we are at the start of a fresh line and precede each line
            with the provided indentation string.
            */
            
        if (stdout == null)
             throw nullInterfaceException;
        if (caption != null)
             stdout.println(caption);
        if (indent == null)
             indent = emptyString;
                // treat null String references as empty-String references
        stdout.println
            (indent + "values must be in Java floating-point format");
        stdout.print(indent);                           /* 0.11 */
        if ( java.lang.Double.isNaN(tolerance) )
             stdout.print("NaN, ");                     /* 0.11 */
        if (min == java.lang.Double.NEGATIVE_INFINITY)
             {  stdout.print(min);
                stdout.print(", from ");
                stdout.println(-java.lang.Double.MAX_VALUE);
                stdout.print(indent + indent);
                }
        else {  stdout.print("from ");                  /* 0.11 */
                stdout.print(min);
                }
        stdout.print(" to ");
        if (max == java.lang.Double.POSITIVE_INFINITY)
             {  stdout.print(java.lang.Double.MAX_VALUE);
                stdout.print(", ");
                };
        stdout.println(max);
    } // describeDouble

        
    public static double validatedDouble
            (   double value,
                        // the value to be validated
                java.lang.IllegalArgumentException rejection,
                        // the exception to be thrown, or null
                double min,
                double max,
                double tolerance)
            throws java.lang.IllegalArgumentException
    {   /*  VALIDATE DOUBLE FLOATING-POINT VALUE
            This auxiliary procedure is available as a class member for
            filtering data to ensure that the values satisfy the range
            requirements of the application as specified by the min, max,
            and tolerance values.
            
            If the value does not satisfy the validation requirements, it
            is rejected by throwing the rejection RuntimeException.
            
            If null is provided for the rejection exception, a default
            IllegalArgumentException will be used instead.  
            
            None of min, max, and tolerance are ever invalid, although certain
            combinations of values prevent the value from ever being acceptable.
            */
            
        if (java.lang.Double.isNaN(value) 
                       && java.lang.Double.isNaN(tolerance))
             return value;
             /* allowing a NaN to pass through */
             
        /* Additional tolerance cases are not yet implemented */
                            
        if (min <= value && value <= max)
             return value;
             /* because the input is fully valid.  */
        
        throw rejectDouble(value, rejection);
        
        } // validatedDouble(double)
                

    /*  INTEGER VALUE INPUT METHODS 
        ***************************
        */
        
    public static int parsedInteger
            (   String text,    
                java.lang.IllegalArgumentException rejection)
            throws java.lang.IllegalArgumentException
    {   /*  0.09 utility operation for tossing unacceptable integer
            forms and returning the successfully-parsed ints.
            */
        try 
        {   return java.lang.Integer.parseInt
                            (text == null ? emptyString : text);
                            // 
            }
        catch (NumberFormatException n)
        {   throw rejectText(text, rejection);
            }
            
        } // parsedInteger filter
        
        
    public int promptedInteger
            (   String prompt,
                        // the text of the prompt
                String indent,
                        // the prefix on every line of output
                NoPromptedEntryException noEntryEx
                )
            throws java.io.IOException, NoPromptedEntryException                    
    {   /*  promptedInteger() version that uses default min, max values.
            */
        return promptedInteger(prompt, indent, noEntryEx,
                               java.lang.Integer.MIN_VALUE,
                               java.lang.Integer.MAX_VALUE );
        } // .promptedInteger (exception default)
        
        
    public int promptedInteger
             ( String prompt,
                        /* the text for inviting input */
               String indent,
                        /* the prefix on every line of output */
               NoPromptedEntryException noEntryException,
                        /* thrown if there is no entry, defaulted if null */
               int min,
                        /* the least acceptable value in the range */
               int max
                        /* the maximum acceptable value in the range */
               )
            throws java.io.IOException, 
                   NoPromptedEntryException
                /* There is nothing to be done about IOExceptions.
                   The noPromptedEntryException is the easiest we could 
                   come up with for applications to catch easily without
                   confusion.
                   */
                   
    {/* .promptedInteger() prompts for input until an acceptable value 
        is entered or no entry is provided (e.g., the operator just 
        presses ENTER).
        */
        if (prompt == null)
            prompt = emptyString;
        if (indent == null)
            indent = emptyString;

        while (true)
        {   /* prompt for the input until we return with a result */
            
            String text = cleanedPrompt(prompt, indent, noEntryException);
                   /* can throw IOException and NoPromptedEntryException
                      */
            try
            {   return diagnosedInteger(text,
                                        stdout,
                                        indent + "unacceptable entry: ",
                                        indent,
                                        internalValidationException,
                                        min, max );

                } // try
                
            catch (java.lang.IllegalArgumentException a)
            {   /* We have diagnosed an unacceptable format or range
                   and we drop through to take another shot at it. */
                stdout.println(indent + 
                           "To make no entry, press ENTER.");
                } // catch internalValidationException

            } // while still needing a correct entry
            
        } // .promptedInteger (exception)
        
    
    public int promptedInteger
            (   String prompt,
                        // the text of the prompt
                String indent
                        // the prefix on every line of output
                )
            throws java.io.IOException                  
    {   /*  promptedDouble() version that uses default min, max 
            and noEntry values.
            */
        return promptedInteger(prompt, indent,
                               java.lang.Integer.MIN_VALUE,
                               java.lang.Integer.MIN_VALUE+1,
                               java.lang.Integer.MAX_VALUE  );
        } // .promptedInteger() with no surprise values
        
        
    public int promptedInteger
             ( String prompt,
                        /* the text for inviting input */
               String indent,
                        /* the prefix on every line of output */
               int noEntry,
                        /* returned if there is no entry */
               int min,
                        /* the least acceptable value in the range */
               int max
                        /* the maximum acceptable value in the range */
               )
            throws java.io.IOException
                /* There is nothing to be done about IOExceptions.
                   */
                   
    {/* .promptedInteger() prompts for input until an acceptable value 
        is entered or no entry is provided (e.g., the operator just 
        presses ENTER).
        */
        try
        {   return promptedInteger(prompt, indent,
                                  defaultNoEntryException,
                                  min, max );
            }
        catch (NoPromptedEntryException x)
        {   return noEntry;
            }
        
        } // .promptedInteger(noEntry)

        
    public static int diagnosedInteger
            (   String text,
                    // the value to be converted and verified
               IConOut stdout, 
                    // console for presenting any diagnostics
                String caption,
                    // the caption used if the entry is rejected
                    // null to suppress presentation of a caption
                String indent,
                    // indentation used on all non-caption lines
                java.lang.IllegalArgumentException rejection,
                   int min,
                   int max
                )
            throws java.lang.IllegalArgumentException,
                   java.lang.NullPointerException
    {   /* Validate the given text as a double */
        if (stdout == null)
             throw nullInterfaceException;
         
        int value;
        
        try
        {   value = parsedInteger(text, internalValidationException);
            }
        catch (IllegalArgumentException ex)
        {   /* Generate the invalid format case for the input. */

            describeInteger(stdout, 
                            ( caption == null ? null
                                              : caption + '"'+text+'"' ),
                            indent, min, max );
                           
            throw rejectText(text, rejection);   
            }
                
        return diagnosedInteger(value, 
                               stdout, caption, indent,
                               rejection, min, max );

        } // diagnosedInteger(text)

        
    public static int diagnosedInteger
            (      int value,
                    // the value to be converted and verified
               IConOut stdout, 
                    // console for presenting any diagnostics
                String caption,
                    // the caption used if the entry is rejected
                    // null to suppress presentation of a caption
                String indent,
                    // indentation used on all non-caption lines
                java.lang.IllegalArgumentException rejection,
                   int min,
                   int max
                )
            throws java.lang.NullPointerException,
                   java.lang.IllegalArgumentException
                   
    {   /* Diagnose an int value for validity against the parameters. */
        
        if (stdout == null)
             throw nullInterfaceException;
         
        try
            {   return validatedInteger(value,
                                        internalValidationException,
                                        min, max );
                /* throwing IllegalArgumentException for a range failure. */
                } // try
            
            catch (java.lang.IllegalArgumentException a)
            {   /* We have an unacceptable range or special-value
                   case and we drop through to have it explained. */
                } // catch IllegalArgumentException

            /*  Describe the format and range that works 
                along with any captioned value report */

            describeInteger(stdout, 
                             ( caption == null ? null
                                               : caption + value ),
                            indent, 
                            min, max );
                           
            throw rejectInteger(value, rejection);
            
        } // diagnosedInteger(int)

        
    static public void describeInteger
            (   IConOut stdout,     // output destination
                 String caption,    // optional unindented caption
                 String indent,     // indentation on description lines
                    int min,        // parameters of the required text.
                    int max )
            throws NullPointerException
    {   /*  Provide a static description (on any console) of the acceptable
            input according to the specified min and max values.
            Assume we are at the start of a fresh line and precede each line
            with the provided indentation string.
            */
            
        if (stdout == null)
             throw nullInterfaceException;
        stdout.println();
        if (caption != null)
             stdout.println(caption);
        if (indent == null)
             indent = emptyString;
                // treat null String references as empty-String references
        stdout.println
            (indent + "values must be in Java int value format");
        stdout.println(indent + "from " + min + " to " + max + ".");

    } // describeInteger

        
    public static int validatedInteger
            (   int value,
                        // the value to be validated
                java.lang.IllegalArgumentException rejection,
                        // the exception to be thrown, or null
                int min,
                int max )
            throws java.lang.IllegalArgumentException
    {   /*  VALIDATE INTEGER VALUE
            This auxiliary procedure is available as a class member for
            filtering data to ensure that the values satisfy the range
            requirements of the application as specified by the min
            and max values.
            
            If the value does not satisfy the validation requirements, it
            is rejected by throwing the rejection IllegalArgumentException.
            
            If null is provided for the rejection exception, a default
            IllegalArgumentException will be used instead.  
            
            None of min and max are invalid, although certain combinations
            prevent the value from ever being acceptable.
            */
            
        if (min <= value && value <= max)
             return value;
             /* because the input is fully valid.  */
        
        throw rejectInteger(value, rejection);
        
        } // validatedInteger

} // class PromptedIO


                            /*  end of PromptedIO.java  */
