/* info.odma.practical100.OdmInterface.java                    0.05alpha
 * The OdmConnection interface provides common features that apply to
 * all interfaces of the info.odma.practical100 package.  The methods
 * are defined in this one place for consistent definition and maintenance
 * of any differences.
 *    The interfaces OdmConnection and OdmDocument each extend OdmInterface.
 * There is no practical100 object that implements only OdmInterface.
 */

package info.odma.practical100;

public interface OdmInterface
{
    java.lang.String interfaceImplementation();
        /* text that identifies the implementation of the interface.
           This string is useful in troubleshooting and in identifying
           the implementation in logs and displays.
           */
        /*XXX This may not be necessary if toString is already an useful
           way to identify the implementation of an interface.
           */

    boolean connectionAvailable();
        /* True when there is an ODMA connection available for use.
           When the result is false, all operations provide their null
           behavior.
               Null response: false.
           */

    void release();
        /* Used by applications to announce that no further use of the
           interface is required.  This permits resources associated with
           the interface to be released as soon as all other dependencies
           on them are also released.
               It is not necessary to use release().  Resources will always
           be released automatically when it is determined that no further
           use is possible.  Using release() expedites early return of
           resources and may improve system performance.
               Following a release(), the interface will only deliver its
           null responses.  This operation impacts every reference by the
           application to the same interface instance.  Do not use this
           operation when there may be other references that require the
           interface to remain active.
               IMPORTANT: release() on a document interface does not return
           any changed document to the DMS.  Other methods must be used
           to accomplish that before release() on a document interface.
           document interface.  Any pending or working document associated
           with a document interface will be treated as abandoned.  Content
           that has not been committed to the ODMA DMS will be lost.  This
           is often the desired behavior.
               Null behavior: no operation (any useful release has
           already been performed)
           */

    } /* OdmInterface */


/* 0.04 2006-10-22-23:55 Make interface public for availability in public
        extensions.
   0.03 2006-10-22-17:12 Improve comments, add interfaceImplementation().
   0.02 2006-10-22-15:54 Document null behaviors and correct class name
   0.01 2006-10-22-13:56 Obtain clean compile of the new class.
   0.00 2006-10-22-12:50 Derive from common parts of the 0.01alpha
        Connection and Document interfaces.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmInterface.java 4     06-10-23 0:38 Orcmid $
   */

/*       *** end of info.odma.practical100.OdmInterface.java ***       */