/* info.odma.practical100.OdmNullConnection.java 0.03        dh:2006-11-29
 *
 * The OdmNullConnection class implements null behavior only.  There is no
 * connection, no default DMS, and all operations provide their null
 * behavior.  Instantiations are generally used solely by their interface,
 * as in
 *      odmConnection myConnection = new OdmNullConnection("MyAppId");
 *
 * This class is useful for regression testing an application for correct
 * implementation of null connection situations.
 *
 * If the application has provision for suppressing ODMA-aware behavior
 * as a configuration option, using this class allows all ODMA-aware code
 * to remain unchanged.  The null connection will automatically cause the
 * correct non-ODMA behavior.
 *
 * This class provide minimal resource requirements and there should be
 * no noticeable overhead when it is used to avoid ODMA-aware behavior
 * as an user's configuration choice.
 *
 * Finally, the ODMJNI classes that detect and operate with actual
 * connections to the ODMA Connection Manager are created by extending
 * this class, with the null behaviors obtainable from the super
 * class implementations.
 */

package info.odma.practical100;

public class OdmNullConnection implements OdmConnection
{
    /* Instance Variables and Constructor
     * ----------------------------------
     */

    protected OdmPendingDocument nullPending = new OdmNullPendingDocument();
        /* Null pending-document interface implementation. */

    protected OdmWorkingDocument nullWorking = new OdmNullWorkingDocument();
        /* Null working-document interface implementation.
           These interface references are created so that we don't
           have to keep instantiating more of them.
           */

        /* FIXME: These standard null cases all have localOperationRequested
           set.  There are additional stock null cases, and we should be
           able to obtain them by constructor variation in the future.
           This will be resolved when OdmNullConnection is extended to
           implement true connection functions.
           */


    java.lang.String odmAppId;
        /* The validated Application ID string available to
           other implementations as needed. */


    public OdmNullConnection(java.lang.String AppId)
    {   /* Associate the specified Application ID with the connection. */

        odmAppId = AppId;

        /*FIXME The validation of Application ID strings should
          be implemented, and an unchecked exception thrown, even
          in the null connection implementation.  When functioning
          implementations are developed as subclasses of this one,
          it is this constructor that does the validation work.
          */
        }


    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return "ODMJNI 1.0 0.05alpha OdmNullConnection Implementation";

        /* FIXME: Look at the default toString() results for these
           interfaces and see what can be done with those instead or
           in addition to this, which is intended to be moderately
           readable by humans.
           */
        }


    public boolean connectionAvailable()
    {   /* There is no connection available.
           */

        return false;
        }


    public void release()
    {   /* There are no resources that require release. The nullPending
           and nullWorking references must be retained as long as this
           instance is reachable, null connection or not.
           */

        return;
        }


    /* OdmConnection Interface Method Implementations
     * ----------------------------------------------
     */

    public boolean dmsDefaultAvailable()
    {   /* There is no default DMS available. */

        return false;
        }


    public OdmPendingDocument acceptNewDocument()
    {   /* The operation must fail with a null pending document */

        return nullPending;
        }


    public OdmWorkingDocument chooseDocument()
    {   /* The operation must fail with a null working document */

        return nullWorking;
        }


    public OdmWorkingDocument openKnownDocument(java.lang.String docID)
    {   /* This operation must also fail with a null working document. */

        return nullWorking;

        /* FIXME.  The standard validation of ODMA Document IDs should
           be performed even in the case of a null connection.  The
           unchecked exception is promised as a standard behavior.
           */
        }


    } /* OdmNullConnection */


/* 0.03 2006-11-30-00:26 Make nullPending and nullWorking protected so that
        they can be used by subclasses of OdmNullConnection in odmjni100.

   0.02 2006-10-23-14:52 Remove the cyclic dependencies with OdmNullDocument
        instances, since we don't need it.

   0.01 2006-10-22-23:43 Make all methods public.

   0.00 2006-10-22-21:05 alpha-level version for the first evolutionary
        prototype of the OdmNullConnection implementation.  This class will
        be maintained consistent with the OdmConnection interface and its
        null behaviors as the prototype package is evolved.

   $Header: /ODMdev/info/odma/practical100/OdmNullConnection.java 4     06-11-30 0:29 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmNullConnection.java ***     */