/* info.odma.odmjni100.OdmJniBind.java 0.08                  dh:2006-11-30
 *
 * The OdmJniBind class is a class of static-only methods that provide
 * dynamic connection between a Java-based ODMA-aware application and the
 * ODMJNI 1.0 classes that implement info.odma.practical100 interfaces
 * using the ODMA Connection Manager and ODMA API.
 *
 * The only public method is OdmJniBind.application(appID).  It accepts
 * the chosen ODMA Application ID of the application and returns the
 * info.odma.practical100.OdmConnection interface to be used for further
 * operations.
 *
 * Typical start-up is via a statement such as
 *
 *      odmConnection myConnection = OdmJniBind.application("MyAppId");
 *
 * All other methods of this class are reserved for private coordination
 * among the odmjni100 implementation classes.
 */

package info.odma.odmjni100;

public class OdmJniBind
{
    /* This is a class of exclusively-static methods used to coordinate
     * the instantiation of other odmjni100 package classes and to
     * implement access to the OdmNative100 apparatus via static native
     * methods.
     *
     * All odmjni100 native methods are implemented on this class.  That
     * way the odmjni100.dll is tied to this single class and is fully-
     * loaded with the loading of this class (or close enough to that).
     */


    private static native int jniVersion();
        /* The version of JNI in two halves of an int, as
           delivered by JNI Ienv.GetVersion().

           This is used to confirm access to JNI and the odmjni100 DLL.  It
           is a sanity-check function in the startup process.

           This is used by the getVersion() method.
           */



    public static java.lang.String getVersion()
    {   /* Convert the JNI version number to a correctly-formatted String.
           */

        int jVersion = jniVersion();

        int verMajor = jVersion >>> 16;

        int verMinor = jVersion - (verMajor << 16);

        return "" + verMajor + "." + verMinor;

        } /* getVersion */



    private static native long getIodmNative(java.lang.String appID);
        /* This native function requests creation of an IodmNative
           object and return of a reference to its  IodmApplication100
           interface.  This reference is disguised as a Java long.
           This interface will be held until a freeIodmNative operation
           is performed with it, at which point the particular reference
           is no longer valid.
           */


    static long getInterfaceRef(long interfaceReturn)

    {   /* To avoid callbacks and provide status as well as interfaces,
           the native methods that return references to interfaces
           use their long returns to indicate error conditions as well.

           The returned long value is either an error status or it is
           an interface reference.  It is never both.

           This function examines a returned long value and delivers
           either the interface reference (a nonzero value) or 0.
           Here, 0 means there is no reference and no attempt to use
           the interface should occur.

           To find out what the error status is, use the getIfaceError
           method.
           */

        if (interfaceReturn == (interfaceReturn & 0x1F) )
             return 0L;
                /* Because the value is too small to be a reference */
        else return interfaceReturn;
                /* Because the value is not an error status value. */

        } /* getInterfaceRef */



    static int getInterfaceStatus(long interfaceReturn)

    {   /* If the interfaceReturn value is an error status, that
           value is returned.  Otherwise, 0 is returned.

           Note that a NULL (0) interfaceReturn will simply
           be treated as a null reference and a 0 status.
           We don't expect to have any of those.
           */

        if (interfaceReturn == (interfaceReturn & 0x1F) )
             return (int) interfaceReturn;
                /* Because the value is in error-status range */
        else return 0;
                /* Because the value is not in error-status range. */

        } /* getInterfaceStatus */


    static native long holdNativeInterface(long interfaceRef);
        /* When an operation has received an interface reference
           as a parameter, that reference is only valid for use
           for the duration of the method (or constructor).

           This function returns an interfaceRef disguise that
           has been held for the caller.  It is then necessary
           for the caller to free the resulting interfaceRef when
           it is no longer required, and before the object holding
           the reference is released.
           */


    static native void freeNativeInterface(long interfaceRef);
        /* this native function will release the provided interface
           reference.  If the interface reference is NULL (0) no
           action is taken.  Otherwise the reference is released
           and the variable that held it should be set to 0.

           Only the one reference is released.  The implementation
           of the interface is not released until all interface
           references that are being held are individually released.
           */


    static native boolean hasConMan(long interfaceRef);
        /* This native function reports whether or not OdmNative100
           has linked the ODMA Connection Manager or not.
           */


    static native boolean hasDefaultDMS(long interfaceRef);
        /* This native function reports whether or not OdmNative100
           has acquired a Default DMS for the application or not.
           */

    static native long selectDoc(long interfaceRef);
        /* This native function will selectDoc if it can and return
           an interface reference for a working document or else
           return a result code.

           The operation returns a NULL interface reference if
           a non-interface reference is provided as input.
           */


    public static
        info.odma.practical100.OdmConnection
            application(java.lang.String appId)

    {   /* Associate the specified Application ID with the application
           and deliver an interface appropriate to the achievement of
           a binding or not. */

        long rIface = getIodmNative(appId);
            /* FIXME: We should validate appId and throw an unchecked
                  exception before passing the string to GetIodmNative.
                  This way, getIodmNative will silently fail and we
                  won't know why.
                  */

        if (getInterfaceRef(rIface) == 0)
             return new info.odma.practical100.OdmNullConnection(appId);
                /* Because we did not get an Interface. */

        else {  /* Instantiate an OdmJniApp to implement the interface.*/

                info.odma.practical100.OdmConnection
                    OdmApp = new OdmJniApp(appId, rIface);
                    /* Using our package's implementation.  The OdmJniApp
                       constructor must arrange to hold its own copy of
                       rIface, releasing that interface reference when
                       it is no longer needed. The appId is preserved
                       as part of the OdmNullConnection implementation
                       underneath.  */

                freeNativeInterface(rIface);
                    /* We no longer need our own reference and release
                       it now.  If OdmJniApp is holding its own copy,
                       it has reserved that one itself. */

                return OdmApp;
                }


        }

    static

        {   /* Static initialization of this class specifies the
               loading of the only DLL that we'll use. */

            System.loadLibrary("odmjni100");

            } /* static initialization */

    } /* OdmJniBind */



/* 0.08 2006-11-30-00:06 Add selectDoc native method.

   0.07 2006-11-29-21:46 Add hasDefaultDMS native method.

   0.06 2006-11-29-20:52 Add hasConMan native method.

   0.05 2006-11-29-18:06 Add holdNativeInterface native method.

   0.04 2006-11-29-16:56 Add note about unchecked exception needed on
        validation of appId.

   0.03 2006-11-29-12:45 Change the parameters provided to the OdmJniApp
        constructor to match its definition.

   0.02 2006-11-29-00:33 Add getIodmNative and the supporting methods.
        Have OdmJniBind.application deliver an OdmJniApp when an interface
        is obtained successfully.

   0.01 2006-11-28-18:17 Add an useful getVersion implementation that
        returns a result that we can use if we want.

   0.00 2006-11-28-14:58 Introduce "null" binding function that simply
        confirms package-level JNI binding to odmjni100.dll is
        working properly.

   $Header: /ODMdev/info/odma/odmjni100/OdmJniBind.java 10    06-11-30 0:34 Orcmid $
   */

/*             *** end of info.odma.odmjni100.OdmJniBind.java ***         */