/* info.odma.practical100.OdmConnection.java                    0.05alpha
 *
 * The OdmConnection interface holds the connection to ODMA that is
 * is available to the currently-running application.  A reference to
 * this interface should be held as long as it is possible the application
 * will have requests to create and access further documents in support of
 * ODMA-aware operation.
 */

package info.odma.practical100;

public interface OdmConnection extends OdmInterface
{
    boolean dmsDefaultAvailable();
        /* True when there is a default ODMA DMS available for the
           current application.  acceptNewDocument() and chooseDocument()
           operations are always performed with a default ODMA DMS that
           has been assigned for use with the current application.
               Null response: false.
           */

    OdmPendingDocument acceptNewDocument();
        /* Used to offer content for making a new managed document.
           This is often for a fresh document that has just been
           created in an application.  It can also be for a "Save As ..."
           of content obtained from a different location or DMS.
               Information available through the returned Document interface
           indicates whether the document should be delivered to the
           DMS or some other course of action is required.
               If there is no default DMS available, a "null-document"
           is returned with indication that the application should use its
           own dialog for determining how to save a new document.
               Null behavior: a pending-document interface for a null-
           document implementation is returned.
               FIXME: There may be parameters required when there is other
           than a null implementation here.
           */

    OdmWorkingDocument chooseDocument();
        /* Requests that the ODMA DMS choose a document for the application
           to use.  This is typically when the application user requests
           opening of a document.  The ODMA connection is given first
           refusal.
               Information available through the returned Document interface
           indicates whether a managed-document has been returned for the
           application's use or a different course of actions is required.
               If there is no default DMS available, a "null-document" is
           returned with indication that the application should use its
           own dialog for choosing a document.
               Null behavior: a working-document interface for a null-
           document implementation is returned.
               FIXME: Verify that no parameters are required for this
           operation at the level of simplicity desired for practical100.
           */

    OdmWorkingDocument openKnownDocument(java.lang.String docID);
        /* Requests that the ODMA connection open a known managed document
           having the docID parameter for its ODMA Document ID
               If the identified document is accessible and the application
           account is authorized to obtain it, the request is handled the
           same as if the identified document had been selected in a
           chooseDocument() operation.
               Information available through the returned Document interface
           indicates whether a managed-document has been returned for the
           application's use or a different course of actions is required.
               If connectionAvailable is false, a "null-document" is
           returned with indication that there is no DMS for providing
           the document.
               FIX ME: This operation will not accept an ill-formed docID
           and an unchecked exception will be thrown, in the same manner
           as for ill-formed appID.  Although the exception is unchecked,
           its class should be declared in this package and it should
           be documented as thrown by this method.
               Null behavior: a working-document interface for a null-
           document implementation is returned.
           */

    } /* Connection */


/* 0.04 2006-10-22-20:32 Make interface public.
   0.03 2006-10-22-17:00 Provide comments and clean compile to work with
        0.05alpha versions of OdmPendingDocument and OdmWorkingDocument
   0.02 2006-10-22-14:00 Modify for new name and extending odmInterface
   0.01 2006-10-19-00:09 Obtain clean compilation
   0.00 2006-10-18-21:40 alpha-level version for the first evolutionary
        prototype of ODMJNI components.  This interface is intended to
        become stable very quickly during early testing and application
        integration.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmConnection.java 7     06-10-22 20:44 Orcmid $
   */

/*       *** end of info.odma.practical100.OdmConnection.java ***      */