/* info.odma.practical100.OdmDocument.java                     0.05alpha
 * The OdmDocument interface provides common features that apply to
 * those interfaces of the info.odma.practical100 package that represent
 * individual managed documents.  The methods are defined in this one place
 * for consistent definition and maintenance.
 *     OdmDocument extends OdmInterface.
 *    The interfaces OdmPendingDocument and OdmWorkingDocument each extend
 * OdmDocument.  There is no practical100 object that implements only
 * OdmDocument.
 */

package info.odma.practical100;

public interface OdmDocument extends OdmInterface
{
    boolean dmsAvailable();
        /* True when there is an available ODMA DMS associated with the
           document for which this interface applies.
               The methods defined below provide details on which an
           appropriate course of action can be based whether or not
           there is a DMS available.
               Null response: false
           */

    /*FIXME It may be important to have the ODMA DMS ID and a title for
      the DMS available for reporting by the application to the operator
      to give some visibility to there being a DMS involved in the
      operations being carried out in the application.
          It is also important that such information be stable and fixed
      and not dependent on any further operations that are performed using
      the interface.  dmsAvailable() and other values available here will
      be preserved until release()
      */

    boolean operationSucceeded();
        /* True when the last operation involving this Document interface
           succeeded.  The first operation with a Document interface is
           the operation that returns it as a result.  Further operations
           have meaningful results only when operationSucceeded() is true.
               Null response: false
           */

    boolean operationCancelled();
        /* True when the operation did not succeed because it was
           cancelled, often at the request of the application operator
           through interaction with the DMS.
               Null response: false
               FIXME.  If a DMS reports that an operation is cancelled in
           error (it has happened), the user may find themselves unable to
           save a working document before closing the application.  The
           application design should always provide a way to save locally
           in an application-shutdown situation.  There needs to be better
           explanation of this situation and how to prevent it in the
           usage scenario documentation for ODMJNI.
           */

    boolean localOperationRequested();
        /* True when the operation did not succeed because the application
           operator, or ODMA, report that the application should provide
           a local operation instead of using an ODMA DMS operation.
               Null response: true
           */

        /* At most one of the above operations will return true following
           an operation.  When none return true, the operation failed.
           There is generally no action to perform that will remove the
           failure condition.  ODMA-aware applications should be designed
           to operate defensively on behalf of their users when failure
           occurs.
           */

    } /* OdmDocument */


/* 0.03 2006-10-22-23:59 Make interface public. Leaving it non-public
        prevents visibility outside of the package.
   0.02 2006-10-22-20:42 Make interface non-public to see if methods still
        work on extensions even if the interface is not separately usable.
   0.01 2006-10-22-15:54 obtain clean compilation of the interface.
   0.00 2006-10-22-14:39 refactoring of common operations used for both
        OdmPendingDocument and OdmWorkingDocument.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmDocument.java 3     06-10-23 0:38 Orcmid $
   */

/*        *** end of info.odma.practical100.OdmDocument.java ***       */