/* info.odma.practical100.OdmNullDocument.java                0.05alpha
 *
 * The OdmNullDocument class implements the common null behaviors for
 * all of the info.odma.practical100 document classes.  This class is
 * not used independently.  It is a foundation that is extended to
 * implement the OdmNullPending and OdmNullWorking classes.
 */

package info.odma.practical100;

class OdmNullDocument
{
    /* FIXME: There are no special constructors or instance-private data.
       That is likely to change in the future, when different cases
       of null document need to be constructed easily.  The current
       behavior can remain that of the default constructor, however.
       */


    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     *
     * We are leaving these as package private to see if that creates
     * any problem with interface implementation or whether everything
     * works where only the interface gets to see the methods elsewhere.
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return "ODMJNI 1.0 0.05alpha OdmNullDocument Implementation";
            /* This interface will usually be over-ridden. */
        }


    public boolean connectionAvailable()
    {   /* There is no connection available. */

        return false;
        /* FIXME: It is possible for there to be a connection and still have
           null documents.  This and other variations need to be handled by constructor variations.
           */
        }


    public void release()
    {   /* There are no resources that require release.
           */

        return;
        }


    /* OdmDocument Interface Method Implementations
     * --------------------------------------------
     */

    public boolean dmsAvailable()
    {   /* There is no DMS available. */

        return false;
        }


    /*FIXME There are additions that may be added to the OdmDocument
      interface that must also be implemented here in the future.  The ones
      for returning various string values will return null, and any that are
      invalid to perform when operationSucceeded() is false will result in
      unchecked exceptions.
      */


    public boolean operationSucceeded()
    {   /* The operation that returned this interface did not succeed. */

        return false;
        }


    public boolean operationCancelled()
    {   /* There are no cancellations possible when there is no connection
           and therefore no DMS available. */

        return false;
        /* FIXME.  There are null documents that can be returned when
           a cancellation happened.  These will have to be set up with
           different constructors or by special subclassing.
           */
        }


    public boolean localOperationRequested()
    {   /* The standard null document implementation indicates that
           local should be used instead.
           */

        return true;
        /* FIXME.  There are null documents that have this be false when
           the operation failed or operationCancelled is true.  That will
           have to be obtained with different constructors or by special
           subclassing.
           */
        }


    } /* OdmNullDocument */


/* 0.02 2006-10-23-15:06 Eliminate global dependency in the constructor,
        since there is no need for these null documents to have any
        global context.  Expanded constructors may be valuable for other
        purposes later.
   0.01 2006-10-22-23:47 Clean up access privileges.
   0.00 2006-10-22-22:05 alpha-level version for the first evolutionary
        prototype of the OdmNullDocument implementation.  This class will
        be maintained consistent with the OdmDocument interface and its
        null behaviors as the prototype package is evolved.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmNullDocument.java 3     06-10-23 15:29 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmNullDocument.java ***     */