/* info.odma.practical100.OdmNullWorkingDocument.java           0.05alpha
 *
 * The OdmNullWorkingDocument class implements the default null behaviors
 * for OdmWorkingDocument interfaces.  This class extends OdmNullDocument
 * to provide the standard default null behavior for working documents.
 */

package info.odma.practical100;

class OdmNullWorkingDocument
        extends OdmNullDocument
        implements OdmWorkingDocument

{   /* Class instance construction */

    /* FIXME: There are no instance variables or special constructors
       for the default OdmNullWorkingDocument.  Additional flavors will
       be introduced as needed as we evolve ODMJNI functionality.
       */


    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     */

    public java.lang.String interfaceImplementation()
    {   /* Return a text string describing this implementation */

        return "ODMJNI 1.0 0.05alpha OdmNullWorkingDocument Implementation";
            /* Over-ride with our identification. */
        }


    /* OdmDocument Interface Method Implementations
     * --------------------------------------------
     *
     * The implementations of OdmNullDocument are all applicable here.
     */


    /* OdmWorkingDocument Interface Method Implementations
     * ---------------------------------------------------
     */


    public java.lang.String docID()
    {   /* No document connection has been established */

        return null;
            /* FIXME.  In some cases a null response might have an
               associated document ID.  This could be the case for
               an openKnownDocument where the request fails.  We
               That seems appropriate but later.
               */
        }


    public java.lang.String docLocation()
    {   /* No document content has been delivered and there is no
           location. */

        return null;
        }


    /* FIX ME: Additional operations will be added as the interface
       is evolved.  This implementation must be kept in step with
       those additions.
       */


    } /* OdmNullWorkingDocument */


/* 0.02 2006-10-23-15:23 Eliminate linking to the connection instance from
        the null document.  The cyclic dependency is unnecessary.
   0.01 2006-10-23-00:47 adjust access privileges of methods to be public
        for the interface implementation, although the class remains
        package-private.
   0.00 2006-10-22-23:13 alpha-level version for the first evolutionary
        prototype of the OdmNullWorkingDocument implementation.  This class
        will be maintained consistent with the OdmWorkingDocument interface
        and its null behaviors as the prototype package is evolved.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmNullWorkingDocument.java 3     06-10-23 15:31 Orcmid $
   */

/*   *** end of info.odma.practical100.OdmNullWorkingDocument.java ***   */