/*
 * Decompiled with CFR 0.152.
 */
package info.odma.odmjni100;

import info.odma.odmjni100.OdmJniBind;
import info.odma.odmjni100.OdmJniPend;
import info.odma.practical100.OdmError;
import info.odma.practical100.OdmNull;
import info.odma.practical100.OdmNullWorkingDocument;
import info.odma.practical100.OdmPendingDocument;
import info.odma.practical100.OdmViewingDocument;
import info.odma.practical100.OdmWorkingDocument;

class OdmJniView
extends OdmNullWorkingDocument
implements OdmViewingDocument,
OdmWorkingDocument {
    final OdmNull nullDocument;
    long rNativeDocument;
    boolean isAvailable;
    private boolean isDmsAvailable;
    private boolean isOperationSucceeded;
    private boolean isLocalOperationRequested;
    boolean isViewOnly;
    private boolean knowDocId;
    private String ourDocId;
    private boolean knowDocLocation;
    private String ourDocLocation;
    private boolean knowWinTitle;
    private String ourWinTitle;
    private boolean knowDmsAuthor;
    private String ourDmsAuthor;
    private boolean knowDmsDocName;
    private String ourDmsDocName;
    private boolean knowDmsDocType;
    private String ourDmsDocType;
    private boolean knowDmsFormatName;
    private String ourDmsFormatName;

    void resetProps() {
        this.knowDocId = false;
        this.ourDocId = null;
        this.knowDocLocation = false;
        this.ourDocLocation = null;
        this.knowWinTitle = false;
        this.ourWinTitle = null;
        this.knowDmsAuthor = false;
        this.ourDmsAuthor = null;
        this.knowDmsDocName = false;
        this.ourDmsDocName = null;
        this.knowDmsDocType = false;
        this.ourDmsDocType = null;
        this.knowDmsFormatName = false;
        this.ourDmsFormatName = null;
    }

    OdmJniView(long l, OdmNull odmNull) {
        super(0);
        this.nullDocument = odmNull;
        this.rNativeDocument = OdmJniBind.holdNativeInterface(l);
        this.isAvailable = true;
        this.isDmsAvailable = true;
        this.isOperationSucceeded = true;
        this.isLocalOperationRequested = false;
        this.isViewOnly = true;
        this.resetProps();
    }

    public String interfaceImplementation() {
        return "ODMJNI 1.0 OdmJniView 0.11 OdmWorkingDocument";
    }

    public boolean available() {
        return this.isAvailable;
    }

    public void release() {
        this.resetProps();
        this.isAvailable = false;
        this.isDmsAvailable = false;
        this.isOperationSucceeded = false;
        this.isLocalOperationRequested = true;
        this.isViewOnly = false;
        OdmJniBind.freeNativeInterface(this.rNativeDocument);
        this.rNativeDocument = 0L;
        super.release();
    }

    public void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public boolean dmsAvailable() {
        return this.isDmsAvailable;
    }

    public boolean operationSucceeded() {
        return this.isOperationSucceeded;
    }

    public boolean localOperationRequested() {
        return this.isLocalOperationRequested;
    }

    public boolean viewOnly() {
        return this.isViewOnly;
    }

    public String docID() {
        if (!this.knowDocId) {
            this.knowDocId = true;
            this.ourDocId = this.rNativeDocument == 0L ? null : OdmJniView.jniDocID(this.rNativeDocument);
        }
        return this.ourDocId;
    }

    private static native String jniDocID(long var0);

    public String docLocation() {
        if (!this.knowDocLocation) {
            this.knowDocLocation = true;
            this.ourDocLocation = this.rNativeDocument == 0L ? null : OdmJniView.jniDocLoc(this.rNativeDocument);
        }
        return this.ourDocLocation;
    }

    private static native String jniDocLoc(long var0);

    private static native String jniDocProp(long var0, int var2);

    public String windowTitle() {
        if (!this.knowWinTitle) {
            this.knowWinTitle = true;
            this.ourWinTitle = this.rNativeDocument == 0L ? null : OdmJniView.jniDocProp(this.rNativeDocument, 4);
        }
        return this.ourWinTitle;
    }

    public String dmsAuthor() {
        if (!this.knowDmsAuthor) {
            this.knowDmsAuthor = true;
            this.ourDmsAuthor = this.rNativeDocument == 0L ? null : OdmJniView.jniDocProp(this.rNativeDocument, 1);
        }
        return this.ourDmsAuthor;
    }

    public String dmsDocName() {
        if (!this.knowDmsDocName) {
            this.knowDmsDocName = true;
            this.ourDmsDocName = this.rNativeDocument == 0L ? null : OdmJniView.jniDocProp(this.rNativeDocument, 2);
        }
        return this.ourDmsDocName;
    }

    public String dmsDocType() {
        if (!this.knowDmsDocType) {
            this.knowDmsDocType = true;
            this.ourDmsDocType = this.rNativeDocument == 0L ? null : OdmJniView.jniDocProp(this.rNativeDocument, 3);
        }
        return this.ourDmsDocType;
    }

    public String dmsFormatName() {
        if (!this.knowDmsFormatName) {
            this.knowDmsFormatName = true;
            this.ourDmsFormatName = this.rNativeDocument == 0L ? null : OdmJniView.jniDocProp(this.rNativeDocument, 6);
        }
        return this.ourDmsFormatName;
    }

    public OdmPendingDocument transferToNewDocument(String string) throws OdmError {
        if (!this.operationSucceeded()) {
            return super.transferToNewDocument(string);
        }
        long l = OdmJniView.jniToNewDoc(this.rNativeDocument, string);
        int n = OdmJniBind.getInterfaceStatus(l);
        if (l == 0L || n > 0) {
            switch (n) {
                case 2: {
                    return this.nullDocument.pendingCancelled();
                }
                case 6: {
                    return this.nullDocument.pendingLocalOperation();
                }
            }
            return this.nullDocument.pendingFailed();
        }
        OdmJniPend odmJniPend = null;
        try {
            odmJniPend = new OdmJniPend(l, this.nullDocument);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        OdmJniBind.freeNativeInterface(l);
        if (odmJniPend == null) {
            return this.nullDocument.pendingFailed();
        }
        return odmJniPend;
    }

    private static native long jniToNewDoc(long var0, String var2);

    static {
        System.loadLibrary("odmjni100");
    }
}

