/*
 * Decompiled with CFR 0.152.
 */
package info.odma.practical100;

import info.odma.practical100.OdmNullFormat;

public class OdmFormat
extends OdmNullFormat {
    private static final int MAX_APPID_LENGTH = 15;
    private static final int MAX_DOCFORMAT_LENGTH = 80;
    private static final int MAX_DOCID_LENGTH = 254;
    private static final int MAX_DMSID_LENGTH = 8;
    private static final String ODMPREFIX = "::ODMA\\";
    private static final int MAX_DOCIDPREFIX_LENGTH = 16;

    private OdmFormat() {
    }

    public static boolean wfAppId(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 1 || string.length() > 15) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= 'z' && (c <= 'Z' || c >= 'a') && (c <= '9' || c >= 'A')) continue;
            return false;
        }
        return true;
    }

    public static boolean wfDocFormatName(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 2 || string.length() > 80) {
            return false;
        }
        if (string.charAt(0) != '.') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= 'z' && (c <= 'Z' || c >= 'a') && (c <= '9' || c >= 'A')) continue;
            return false;
        }
        return true;
    }

    public static boolean wfDocIdPrefix(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < ODMPREFIX.length() + 2) {
            return false;
        }
        if (string.substring(0, ODMPREFIX.length()).compareToIgnoreCase(ODMPREFIX) != 0) {
            return false;
        }
        String string2 = "";
        int n = string.length() > 254 ? 254 : string.length();
        for (int i = ODMPREFIX.length(); i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                return string2.length() >= 1 && string2.length() <= 8;
            }
            if (c < '0' || c > 'z' || c > 'Z' && c < 'a' || c > '9' && c < 'A') {
                return false;
            }
            string2 = string2 + c;
        }
        return false;
    }

    public static String prefixDmsId(String string) {
        if (!OdmFormat.wfDocIdPrefix(string)) {
            return null;
        }
        String string2 = "";
        int n = ODMPREFIX.length();
        char c;
        while ((c = string.charAt(n)) != '\\') {
            string2 = string2 + c;
            ++n;
        }
        return string2;
    }

    public static boolean wfDocId(String string) {
        if (string.length() > 254) {
            return false;
        }
        if (!OdmFormat.wfDocIdPrefix(string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && (c <= '~' || c >= '\u00a1') && c != '\u00ad') continue;
            return false;
        }
        return true;
    }

    public static boolean safeDocId(String string) {
        if (!OdmFormat.wfDocId(string)) {
            return false;
        }
        block3: for (int i = ODMPREFIX.length(); i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '\\': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (c >= '0' && c <= 'z' && (c <= 'Z' || c >= 'a') && (c <= '9' || c >= 'A')) continue block3;
                    return false;
                }
            }
        }
        return true;
    }
}

