/*  IConIO: 0.03 Console Input-Output Interfaces (ALPHA) */
/*  $Header: /Java2/com/orcmid/io/alpha/IConIO.java 3     03-07-12 8:33 Orcmid $ */

            /* This material is valid for use with all java APIs since 
               JDK 1.1.
               
               The development of the IConIO interface family is part of
               demonstration of how component frameworks can be developed
               and then used to enforce interface-by-contract methodologies.
               This version is just for obtaining operational interfaces.
               Tightening for interface-by-contract support will be done
               by further confirmation and testing.
               
               WARNING: THIS IS ALPHA-LEVEL MATERIAL.  THE CLASSES AND
               INTERFACES ARE NOT VERSIONED.  THE MATERIAL IS SUBJECT
               TO CHANGE WITHOUT NOTICE.  THERE IS NO COMMITMENT TO 
               MATURE THE ALPHA MATERIALS TO PRODUCTION QUALITY OR TO A
               RELEASE VERSION.
               */

               
/*  INSTALLATION INSTRUCTIONS
    *************************
    
    1.  For alpha-test usage, this file is placed in a directory
        where the interfaces are to be used by classes to be built there.  
        
    2.  Compile this file.  Five class files will be produced:
    
            IConOut.class       defining interface IConOut
            IConLineIn.class    defining interface IConLineIn 
            IConIn.class        defining interface IConIn 
                                         extending IConLineIn
            IConLineIO.class    defining interface IConLineIO
                                         extending IConOut, IConLineIn
            IConIO.class        defining interface IConIO
                                         extending IConLineIO, IConIn
                                                     
    3.  The files are used, in conjunction with the interface classes, in
        demonstration, confirmation, and testing applications.  The file
        ConIO.java provides classes for reference implementations of these 
        interfaces.  The correct compilation of this file can be confirmed
        by compiling ConIO.java using the same default package/directory.
        
    4.  NOTE: These interfaces are defined for use within a default package.
        They cannot be imported, only used from applications that name the
        classes directly.  The application must be compiled into the same
        directory and executed from that directory.  
    */

           
/*  THE INTERFACES
    **************
    */
    
interface IConOut
{/* 0.01 2003-06-19-11:27 Initial version of IConOut for confirmation,
         testing, and experimental operation.  See the warnings and notes
         in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/IConIO.java 3     03-07-12 8:33 Orcmid $
    */
    
    /* An interface for generic console-level output.  The only methods
       supported are those that are needed for straightforward output to
       any stream or device capable of appearing as a console.  The
       behaviors are defined to be those of java.io.PrintWriter as
       of the J2SE 1.4.1 SDK and Java API edition. Only features that 
       have been stable since JDK 1.1 are relied upon in this interface.
       The PrintWriter form of automatic line flushing can be assumed.
       */
       
    /* WARNING: PROVISIONAL INTERFACE.  THIS INTERFACE IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       CHARACTER SET CONCERNS: These interfaces are defined on the presumption
       that there is appropriate support for Unicode in any implementation of
       this interface and those that extend it.  The availability of appro-
       priate classes for implementation of the interface is pending further 
       confirmation and testing.
       
       The basic difference between this interface and a PrintWriter object
       is that only progressive output operations using printing functions 
       can be performed via IConOut. The user of this interface cannot set any
       error flag, manipulate locks, or close the stream.  Direct write 
       operations are also omitted.
       
       Whether there is any provision for localization is not reflected in
       this interface.  The most one should expect is standard output using
       Java language notations for numeric quantities and the mapping from
       Unicode characters to appropriate data stream character-set encodings.
       
       Some operations are under review with regard to their behavior under
       exceptional conditions.
       */
    
    
    boolean checkError();
        /* perform a flush and then report the error status of the stream.
           Once there is an error of the stream medium or as the result of
           data conversion, the error status is set true and remains true
           from then on.  An user of this interface is not provided with
           any means to set the error status.
           */

    void flush();
        /* Flush the output stream.  To be sure that output is 
           visible when it needs to be seen -- as in making a prompt --
           flush() should always be done. The .checkError() method
           is an alternative that also provides an indication of
           whether operations have been successful up to this point.
           */
    
    
    /* PRINT OPERATIONS.  There is a print operation for each
       fundamental data type.  The output is expected to be the same
       obtained by the .toString() operation of the associated class.
       For strings, the output is expected to be the same as output
       of the individual string characters, in sequence.
       
       This class is highly Java-oriented, in that programming-language
       notions of printing for booleans, ints, floats, and so on are
       employed.  Also, locale requirements are usually not expected to 
       be addressed.
       */
       
    void print(boolean b);
        /* All of the standard print and println functions are
           preserved.  Any of these can lead to the error status
           being set. */
           
    void print(char c);
    
    void print(char[] s) throws java.lang.NullPointerException;
    
    void print(double d);
    
    void print(float f);
    
    void print(int i);
    
    void print(long i);
    
    void print(java.lang.Object obj);
        /* not allowing names Object and String to be obscured. 
           Output of "null" here is fine though. Although this seems
           like an inappropriate case for a non-developer application,
           there is no way to prevent it, since a service that is 
           supplied IConOut to use can alway accomplish the same
           thing using the String case. */
    
    void print(java.lang.String s);
        /* outputs "null" for a null pointer.  I am not happy about that
           here. */
    
    
    /* PRINTLN OPERATIONS. There is a basic println() method and one
       println operation corresponding to every print operation. It is
       recommended that creation of new-lines always be done by an
       explicit println operation.  This provides greater assurance of
       consistent behavior on any platform, in contrast with use of the
       '\n' new-line character code.
       */
       
    void println();
        /* Each println method implies a flush.  A '\n' in the output does
           not.  When in doubt, flush().  Some streams flush on every 
           character.  To be safe, one should make sure there is an explicit
           println(), checkError(), or flush() at a point where all output
           up to this part is to be visible on the target console.
               This is particularly important if a response is expected
           or if the stream is intended to be delivered to an agent or 
           service of some kind and an action is expected.
           */
           
    void println(boolean b);
                   
    void println(char c);
    
    void println(char[] s) throws java.lang.NullPointerException;
    
    void println(double d);
    
    void println(float f);
    
    void println(int i);
    
    void println(long i);
    
    void println(java.lang.Object obj);
    
    void println(java.lang.String s);
        /* Outputs "null" for a null String value.  See print(String s). */
    
    } // interface ConOut

    
interface IConLineIn
{/* 0.01 2003-06-19-11:33 Initial version of IConLineIn for confirmation,
         testing, and experimental operation.  See the warnings and notes
         in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/IConIO.java 3     03-07-12 8:33 Orcmid $
    */
    
    /* An interface for line-oriented console-level input.  The only methods
       supported are those that are needed for character-line
       input from any stream or device capable of appearing as a console 
       input source.  The behaviors are defined to be the same as those of 
       java.io.BufferedReader as of the J2SE 1.4.1 SDK and Java API edition.
       Only features that have been stable since JDK 1.1 are relied upon in 
       this interface.
       */
       
    /* WARNING: PROVISIONAL INTERFACE.  THIS INTERFACE IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       Only progressive input operations using line-oriented input can be
       performed via IConLineIn. The user of this interface cannot mark
       a place, reposition the stream or close the stream.
       
       In addition, there is no provision for reading gulps of input into the
       callers own buffer.  Skipping forward in a stream is also not 
       supported.
       
       Single-character read() operations are not supported by this
       interface.  Using read() can leave the input stream in an unpredictable
       state, especially if the variety of end-of-line conditions are not
       handled properly.  If single-character input is essential to an
       application, use the IConLineIn interface subclass, IConIn.
       */
       
    
    java.lang.String readLine() throws java.io.IOException;
        /* If the source is at the end of the stream, null is returned.
           Otherwise, the source delivers all characters up to but not
           including an end-of-stream, newline ('\n'), carriage-return ('\r'),
           or carriage-return followed by a new-line.  The ending newline
           and/or carriage-return character codes are discarded and not
           delivered in the result.
           */
    
    } // interface IConLineIn


interface IConIn extends IConLineIn
{/* 0.01 2003-06-19-12:42 Initial version of IConIn for confirmation,
         testing, and experimental operation.  See the warnings and notes
         in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/IConIO.java 3     03-07-12 8:33 Orcmid $
    */
    
    /* An interface for single-character and line-oriented console-level 
       input.  This interface adds the read() and ready() operations to the 
       limited operations supported with IConLineIn.
       
       The behavior of read() is defined to be the same as the read
       operation defined by java.io.BufferedReader as of the J2SE 1.4.1 SDK
       and Java API edition.  Only features that have been stable since 
       JDK 1.1 are relied upon in this interface.
       */
       
    /* WARNING: PROVISIONAL INTERFACE.  THIS INTERFACE IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       We may end up not inheriting from IConLineIn depending on the following
       situation.  When an operation is supplied with an IConLineIn, it is not
       appropriate for casting to IConIn to be possible.  Experiments to control
       casting of interfaces and also access to the implementation classes are
       going to be carried out and the available protection confirmed and
       tested.
       */
    
    int read() throws java.io.IOException;
        /* reads a single character from the input source.  The character
           code is returned as an integer in the range 0 to 65535 (0xFFFF).
           If the source is at the end of the stream, -1 is returned.
           
           The ready() operation can be used to determine whether a 
           character is ready to be read without blocking.
         
           When used in conjunction with, or as part of line-oriented reading,
           read() does not deal with line-terminations properly. In particular,
           it is not possible to read beyond a carriage-return character to
           see if there is a following new-line/line-feed character or not.
           
           An appropriate implementation would make a single-character 
           delivery ('\n') for any case encountered and also interact with
           the ready() function properly.  That is not the inherited 
           definition for this operation.
           
           The behavior of ready() is tied to the behavior of read(), 
           and they generally need to be implemented together.  Note that
           ready() does not assure unblocked readLines().  A separate
           readyLine() operation is needed if that case is important
           enough.
           */
           
    boolean ready() throws java.io.IOException;
        /* Returns true if the input stream is ready to be read.
           When the input stream is ready, the next read() operation
           will proceed without blocking.  
               A response of false does not mean blocking will occur,
           it is merely an indication that no assurance can be given.
           However, there must be some assurance that this function will
           deliver true at some point, if the stream truly is ready to
           be read.
           */
           
    } // interface IConIn
  
  
interface IConLineIO extends IConOut, IConLineIn
{/* 0.02 2003-07-12-08:19 typo corrections in description
    0.01 2003-06-19-13:11 Initial version of IConLineIO for confirmation,
         testing, and experimental operation.  See the warnings and notes
         in the text of this declaration.
    $Header: /Java2/com/orcmid/io/alpha/IConIO.java 3     03-07-12 8:33 Orcmid $
    */
    
    /* A single interface that provides for line-oriented input and output
       using a console-level input-output facility.  The only operations
       provided are those that support character-line input and print-style
       output using console-oriented operations.  The behaviors are those
       defined for interfaces IConOut and IConLineIn.
       */
       
    /* WARNING: PROVISIONAL INTERFACE.  THIS INTERFACE IS UNDER DEVELOPMENT
       AND MAY CHANGE. USE THIS VERSION ONLY WITH THE DEFAULT PACKAGE IN
       WHICH IT IS SUPPLIED.
       
       This interface provides the combination of interfaces IConOut and
       IConLineIn.  No additional operations are introduced.
       
       Note that IConIn is not inherited here.  We want sufficient
       granularity to suppress delivery of single-character read() 
       capability to a subordinate service.  In addition, we want
       sufficient granularity to express the precise level of capability
       that is actually required in the signatures of methods for reusable
       services, such as the experimental Console classes.
    */
    
    } // interface IConLineIO;
    

interface IConIO extends IConLineIO, IConIn
{/* 0.03 2003-07-12-08:24 Update description concerning IConLineIn
    0.02 2003-07-11-16:54 Correct to extend IConLineIO instead of
         IConOut, so that IConLineIO is available as a sub-interface.
    0.01 2003-06-19-13:11 Initial version of IConIO for confirmation,
         testing, and experimental operation.  See the warnings and notes
         in the text of the IConOut and IConIn declarations.
    $Header: /Java2/com/orcmid/io/alpha/IConIO.java 3     03-07-12 8:33 Orcmid $
    */
    
    /* This just puts the missing read() and ready() operations in. 
       All of the work is done by inheritance.
       
       IConLineIn is also available via this interface.  It is not clear
       whether casting to IConLineIn or IConLineIO will cut off IConIn usage
       or not.  We want it to do so, but this remains to be verified.
       
       This file will compile without having any interface that is declared
       public or with a name that matches the name of the file.  Apparently,
       the rule for names and exactly one public class is truly only about 
       classes.
       */
       
    } // interface IConIO
    

                            /*  end of IConIO.java */
