@echo off
rem BuildJar.bat 0.04            UTF-8                    dh:2007-04-07
ECHO **   BuildJar.bat 0.04 CONSTRUCTING THE RUNTIME ODMJNI100.jar
ECHO **

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildJar.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST practical100.opt GOTO :FAIL1a
IF NOT EXIST odmjni100.opt GOTO :FAIL1b

set Odm=%CD%

pushd "%OdmClasses%"
jar cf "%Odm%\ODMJNI100.jar" @"%Odm%\odmjni100.opt"
popd
if ERRORLEVEL 1 GOTO :FAIL2

pushd "%OdmClasses%"
jar uf "%Odm%\ODMJNI100.jar" @"%Odm%\practical100.opt"
popd
if ERRORLEVEL 1 GOTO :FAIL2

jar ufm ODMJNI100.jar meta-inf\ODMJNI100.mf @meta-inf\meta-inf.opt
if ERRORLEVEL 1 GOTO :FAIL2


:DONE
echo:
echo **   ODMJNI100.jar CONSTRUCTED
ECHO **   *************************
echo:
echo:     There are no errors or warnings.  This jar can be tested
echo:     and used in building a runtime deployment package.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildJar.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that location.
ECHO **       Verify your OdmDeploy100 configuration and ensure that the
ECHO **       directory holding BuildJar.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1a
ECHO:
ECHO **   THE practical100.opt FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildJar
ECHO **       script.  BuildJar.bat has aborted.
ECHO:
EXIT /B 2

:FAIL1b
ECHO:
ECHO **   THE odmjni100.opt FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildJar
ECHO **       script.  BuildJar.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN OPERATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD THE ODMJNI100.jar package.
rem      The runtime classes are combined into a package for use on the
rem      classpath and for installing in the same directory as the
rem      application, with the ODMJNI 1.0 DLL files too.

rem 0.04 2007-04-07-22:29 Add /meta-inf and manifest material
rem 0.03 2007-03-31-19:38 Add odmjni100.opt along with practical100.opt
rem 0.02 2007-03-31-16:29 Try using ODMJNI100.jar and OdmDeploy100 folder
rem      to get around filename and path objections from the jar utility.
rem 0.01 2007-03-31-15:33 Adjust to use directory ODMJNI1.0 and make
rem      ODMJNI1.0.jar in the same directory.  Start with practical100.opt
rem 0.00 2007-03-29-22:39 customized from the odmjni100 BuildClasses.bat
rem      0.01

rem $Header: /ODMdev/info/odma/OdmDeploy100/BuildJar.bat 5     07-04-09 15:53 Orcmid $

rem                     *** end of BuildJar.bat ***