@echo off
rem BuildZip.bat 0.00            UTF-8                    dh:2007-04-02
ECHO **   BuildZip.bat 0.00 CONSTRUCTING THE RUNTIME %1%.zip
ECHO **       containing the complete runtime .jar and .dll distribution.

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
rem  XXX: We are not going to use Java, but we need to know where
rem       OdmClasses is in order to find the tools directory.
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildZip.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%


:Compile

SET Za=%OdmClasses%\tools\7za.exe
IF NOT EXIST %Za% GOTO :FAIL

IF NOT EXIST odmjni100.jar GOTO :FAIL1a
IF NOT EXIST odmjni100.dll GOTO :FAIL1b
IF NOT EXIST %1.list GOTO :Fail1c

IF EXIST %1.zip ERASE %1.zip
%Za% a -tzip %1.zip @%1.list
if ERRORLEVEL 1 GOTO :FAIL2



:DONE
echo:
ECHO **   *************************
echo **   %1.zip CONSTRUCTED
echo:     There are no errors or warnings.  This zip can be used to
echo:     to unzip-deploy the ODMJNI 1.0 runtime.
echo:
EXIT /B 0


:FAIL
ECHO:
ECHO **   MISSING TOOL %Za%
ECHO **       The 7Za command-line tool must be available in that location.
ECHO **       Verify your OdmDeploy100 configuration and that <folder>\tools
ECHO **       directory has the 7za.exe utility.
ECHO:
EXIT /B 2


:FAIL0
ECHO:
ECHO **   EXECUTE BuildZip.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that location.
ECHO **       Verify your OdmDeploy100 configuration and ensure that the
ECHO **       directory holding BuildZip.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1a
ECHO:
ECHO **   THE odmjni100.jar FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildZip
ECHO **       script.  BuildZip.bat has aborted.
ECHO:
EXIT /B 2

:FAIL1b
ECHO:
ECHO **   THE odmjni100.dll FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildZip
ECHO **       script.  BuildZip.bat has aborted.
ECHO:
EXIT /B 2

:FAIL1c
ECHO:
ECHO **   THE %1.list FILE IS NOT PRESENT IN CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildZip
ECHO **       script.  BuildZip.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN OPERATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD AN ODMJNI100.zip package.
rem      The runtime jar files and the related DLLs and information are
rem      included into a Zip file that is used for distribution.  The
rem      Zip can name the version.

rem 0.00 2007-04-02-17:20 customized from BuildJar 0.03 and verify basic
rem      operation using the 7-zip command-line tool.

rem $Header: /ODMdev/info/odma/OdmDeploy100/BuildZip.bat 1     07-04-02 18:40 Orcmid $

rem                     *** end of BuildZip.bat ***