@echo off
rem BuildJar.bat 0.05            UTF-8                    dh:2007-04-07
ECHO **   BuildJar.bat 0.05 CONSTRUCTING THE Clicker.jar
ECHO **

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd

IF NOT ERRORLEVEL 1 GOTO :Compile
ECHO **   BuildJar.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile

set Odm=%CD%

pushd "%OdmClasses%\info\odma\odmjni100\test\CheckSwing"
jar cf "%Odm%\Clicker.jar" @"%Odm%\Clicker.opt"
rem   XXX this Clicker.opt might be easier to coordinate with the CheckSwing
rem       code if it was all done over in the CheckSwing directory and maybe
rem       shared to here or viceversa?
popd
if ERRORLEVEL 1 GOTO :FAIL2

jar ufm Clicker.jar meta-inf\Clicker.mf @meta-inf\meta-inf.opt
rem   XXX we use our own manifest content and and then an options file
rem       maintained in meta-inf\ to define the additional material that
rem       will be in the meta-inf/ portion of Clicker.jar.
if ERRORLEVEL 1 GOTO :FAIL2



:DONE
echo:
echo **   Clicker.jar CONSTRUCTED
ECHO **   ************************
echo:
echo:     There are no errors or warnings.  This jar can be tested
echo:     and used in building a runtime deployment package.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildJar.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available above that location.
ECHO **       Verify your OdmDeploy100 configuration and ensure that the
ECHO **       directory holding BuildJar.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN OPERATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD THE Clicker.jar package.
rem      The OdmClicker application is built into a package in this
rem      directory along with the ODMJNI100 run-time files.  These are
rem      enough for execution of the Clicker.jar and correct use of
rem      classes, libraries, and the jawt and awt DLLs.

rem 0.05 2007-04-07-09:12 Reorganize the meta-inf\ for creation of the
rem      Clicker.jar manifest and supplementary material.
rem 0.04 2007-04-04-23:08 Add explicit meta-inf directory content also.
rem 0.03 2007-04-03-18:26 Update to have classpath in the manifest (only
rem      version changed here so it is reflected on the transcript).
rem 0.02 2007-04-03-18:04 Switch to using a manifest to set the application
rem      startup class.
rem 0.01 2007-04-03-17:56 Add main entry point via ufe option, using
rem      jar ufm Clicker.jar OdmClicker.  This is not valid for the 1.5 jar
rem 0.00 2007-04-02-22:29 customized from the OdmDeploy100 BuildJar.bat
rem      0.03

rem $Header: /ODMdev/info/odma/OdmDeploy100/test/ClickerJar/BuildJar.bat 11    07-04-07 9:19 Orcmid $

rem                     *** end of BuildJar.bat ***