@echo off
rem RunCheck.bat 0.00                UTF-8                    dh:2007-04-02
echo **   RunCheck.bat 0.00 PERFORMING odmjni100 CONFIRMATION CHECKS
rem       Usage: RunCheck %1 %2
rem              %1 is the name of the application (no .class)
rem              %2 is the name of any Jar (form "\name.jar")
rem                 to use on the class path

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Run
ECHO:
ECHO **   RunCheck.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Run
IF NOT EXIST %1.class GOTO :FAIL1
SET ERRORLEVEL=
rem         This version sets the library path on the command line.
rem         We need a better way to do this in the future.
rem         FIXME: We might want to check for the odmjni100.dll too.
ECHO:
java -cp ".;%OdmClasses%%2" -Djava.library.path=.;..\..\ %1
IF ERRORLEVEL 1 GOTO :FAIL2
EXIT /B 0

:FAIL0
ECHO:
ECHO **   EXECUTE RunCheck.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding RunCheckChoice.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE %1.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       Use Build%1.bat to compile the class.
ECHO:
EXIT /B 2


:FAIL2
ECHO:
ECHO **   ERRORS IN EXECUTION, ERRORLEVEL = %ERRORLEVEL%
ECHO **       Remedy depends on the available error messages from Java.
ECHO:
EXIT /B %ERRORLEVEL%

rem -----1---------2---------3---------4---------5---------6---------7----*

rem RUNNING odmjni100 INTEGRATION CONFIRMATION PROGRAM %1 using the
rem ClassPath augmented by any \odmjni100.jar given as %2.

rem 0.00 2007-01-23-18:22 Customize from RunCheckChoice 0.01

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/RunCheck.bat 1     07-04-02 19:35 Orcmid $

rem                    *** end of RunCheck.bat ***