@echo off
rem BuildDeployTest.bat 0.00         UTF-8                   dh:2007-03-21
ECHO **   BuildDeployTest.bat 0.00 COMPILING DEPLOYMENT TEST CODE
IF "%1" == "" GOTO :USAGE
ECHO:         This %1 application is an experimental confirmation of
ECHO:         different deployment approaches for ODMJNI 0.58beta

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 1 GOTO :Compile
ECHO **   BuildDeployTest.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:USAGE
ECHO:
ECHO **   USAGE:
ECHO **       BuildDeployTest testName
ECHO **
ECHO **   where     testName is the name of the application and
ECHO **        testName.java is the source program to compile
ECHO:
EXIT /B 1


:Compile
IF NOT EXIST %1.java GOTO :FAIL1

rem erase *.class probably not needed for our single-file apps.
rem XXX: ClassPath is probably not needed, but we always set it anyhow.
SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" %1.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   %1.class COMPILED
ECHO **   *****************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via command RunDeployTest.bat %1
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildDeployTest.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding BuildDeployTest.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE %1.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       BuildDeployTest.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildDeployTest %1 into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA APPLICATION TO TEST DEPLOYMENT TECHNIQUES
rem     Build a progression of Java applications that verify some important
rem     features of deployment options for 0.58beta

rem 0.00 2007-03-21-22:10 Customize from BuildSwingApp.bat 0.00.

rem $Header: /ODMdev/info/odma/odmjni100/test/Deploy05/BuildDeployTest.bat 1     07-03-21 22:13 Orcmid $

rem                   *** end of BuildDeployTest.bat ***