/* ListProps.java 0.02               UTF-8                   dh:2007-03-26
 *
 *                      LIST THE JAVA SYSTEM PROPERTIES
 *                      *******************************
 *
 * Just list the system properties so we can see what there is on our
 * Java system.
 */

 class ListProps
 {  /* SIMPLE OUTPUT EXERCISE.
       */


    /* AUXILLIARY OUTPUT PRESENTATION OPERATIONS
       ***************************************** */


    private static final java.lang.String indent = "           ";
            /* Indent below the                    "ListProps> ". */

    private static final java.lang.String stars =  "      **** ";
            /* Used to highlight unexpected results */


    private static void hello(IConOut console)
    {   /* Identify the application and what we are doing here.
           */

        console.println();
        console.println(   "ListProps> 0.02 Enumerate System Properties"
                           );

        } /* hello */


    private static void goodbye(IConOut console)
    {   /* Announce completion of operation */

        console.println();
        console.println("ListProps> exit");
        console.println();
        } /* goodbye */



    private static final IConLineIO stdio = new ConLineIO();
            /* Use a default console input-output implementation */

    private static final IConOut stdout = stdio;

    private static final IConLineIn stdin = stdio;


    /* THE MAIN PROCEDURE AND ITS SUBORDINATE OPERATIONS
       ************************************************* */


    public static void main(String[] args)
    {

        hello(stdout);
        stdout.println();

        for (  java.util.Enumeration e
                  = java.lang.System.getProperties().propertyNames();
               e.hasMoreElements();
               )

            {   java.lang.String propName = e.nextElement().toString();

                stdout.println(indent + propName + ":" );
                stdout.println(indent + "    "
                                      + java.lang.System.getProperty
                                            (propName, "(none)")
                                      );
                }

        stdout.println();
        goodbye(stdout);

        } /* main */



    } /* ListProps */


/* 0.02 2007-03-26-20:45 Recover lost changes to print the propertyNames
        along with the values and provide a complete report.
   0.01 2007-03-25-17:03 Modify the program to list the propertyNames only.
   0.00 2007-03-22-22:02 Make simple program to list all of the
        defined system properties.  This version uses a simple
        System.getProperties().list(System.out) to show what it is like.

   $Header: /ODMdev/info/odma/odmjni100/test/Deploy05/ListProps.java 2     07-03-26 21:23 Orcmid $
   */

/*                       *** end of ListProps.java ***                */
