@echo off
rem RunCheck.bat 0.02                UTF-8                    dh:2007-11-28
echo **   RunCheck.bat 0.02 PERFORMING odmjni100 CONFIRMATION CHECKS
rem
rem       USAGE:
rem
rem           RunCheck checkClass [\lib.jar]
rem
rem       where checkClass is the name of the Check04 class to run, either
rem                        CheckChoice, CheckKnown, or CheckNew
rem
rem               \lib.jar is the optional ODMJNI runtime jar to use at
rem                        the end of the classpath.
rem
rem       The basic classpath is set in OdmJava.bat.
rem
rem       IMPORTANT: For RunCheck to run, the odmjni100.dll library must
rem          be available as well.  When using the development tree, the
rem          odmjni100.dll is expected in %OdmClasses%\info\odma\odmjni100.
rem          When a runtime jar is used, odmjni100.dll is expected to be
rem          located in the same directory as the jar, the %OdmClasses%
rem          directly.
rem
rem          This must be taken into consideration when customizing
rem          OdmJava.bat.


IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Run
ECHO:
ECHO **   RunCheck.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Run
IF NOT EXIST %1.class GOTO :FAIL1
SET ERRORLEVEL=
rem         This version sets the library path on the command line.
rem         We cannot use .jar proximity in this arrangement of
rem         0.54-odmjni100\Clicker.
set ODMJNILIB=%OdmClasses%\info\odma\odmjni100
rem           The location of odmjni100.dll on the development-tree path
IF "%2"=="" GOTO :CheckPath
set ODMJNILIB=%OdmClasses%
rem           The location of odmjni100.dll adjacent to a .jar location

:CheckPath
IF NOT EXIST "%ODMJNILIB%\odmjni100.dll" GOTO :FAIL3
ECHO:
java -cp ".;%OdmClasses%%2" "-Djava.library.path=.;%ODMJNILIB%" %1
IF ERRORLEVEL 1 GOTO :FAIL2
EXIT /B 0

:FAIL0
ECHO:
ECHO **   EXECUTE RunCheck.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding RunCheckChoice.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE %1.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       Use Build%1.bat to compile the class.
ECHO:
EXIT /B 2


:FAIL2
ECHO:
ECHO **   ERRORS IN EXECUTION, ERRORLEVEL = %ERRORLEVEL%
ECHO **       Remedy depends on the available error messages from Java.
ECHO:
EXIT /B %ERRORLEVEL%


:FAIL3
ECHO:
ECHO **   THE odmjni100.dll FILE IS NOT PRESENT IN THE SAME LOCATION AS
ECHO **   THE info.odma.odmjni100 PACKAGE.  ACCORDING TO THE PARAMETERS
ECHO **   TO THIS SCRIPT, IT SHOULD BE IN THE DIRECTORY
ECHO **
ECHO **       %ODMJNILIB%
ECHO **
ECHO **   PLEASE REVIEW YOUR ODMJNI TEST CONFIGURATION AND THE CUSTOMIZATION
ECHO **   OF OdmJava.bat and RunCheck.bat.
ECHO:
EXIT /B 2

rem -----1---------2---------3---------4---------5---------6---------7----*

rem RUNNING odmjni100 INTEGRATION CONFIRMATION PROGRAM %1 using the
rem ClassPath augmented by any \odmjni100.jar given as %2.

rem 0.02 2007-11-29-16:50 Correct identification in the first ECHO command
rem 0.01 2007-11-28-20:55 Convert to work with a local OmdJava.bat and also
rem      automatically locate odmjni100 next to the odmjni100 package,
rem      whether in a development tree or in a jar file.
rem 0.00 2007-01-23-18:22 Customize from RunCheckChoice 0.01

rem $Header: /ODMdev/info/odma/odmjni100/0.57-odmjni100/check04/RunCheck.bat 3     07-11-29 16:50 Orcmid $

rem                    *** end of RunCheck.bat ***