@echo off
rem ExtractPendHeader.bat 0.00       UTF-8                    dh:2007-01-21
ECHO **   ExtractPendHeader.bat 0.00 EXTRACT NATIVE METHOD HEADER
ECHO **       Obtain C/C++ declarations for OdmJniWork native methods.

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   ExtractPendHeader.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST OdmJniPend.class GOTO :FAIL1

SET ERRORLEVEL=
rem     Use all ODMJNI packages and compile everything needed for
rem     OdmJniWork.java
javah -classpath "%OdmClasses%" -o odmjni100p.h info.odma.odmjni100.OdmJniPend
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   odmjni100p.h HEADER EXTRACTED
ECHO **   *****************************
echo:
echo:     There are no errors or warnings.  The header file can be used
echo:     as the basis for definitions to be used in programming and
echo:     compiling the odmjni100.dll file.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE ExtractPendHeader.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that location.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding ExtractPendHeader.bat is the current
ECHO **       working directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE OdmJniPend.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this ExtractHeader
ECHO **       script.  ExtractPendHeader.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN JAVAH USAGE, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of ExtractPendHeader.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem EXTRACT THE odmjni100p.h HEADER FOR ODMJNIPEND NATIVE IMPLEMENTATIONS.
rem      Some of the native methods of odmjni100 are implemented as
rem      static methods on OdmJniPend.  This procedure creates the
rem      C/C++ header file that provides prototypes for those particular
rem      implementations to be created.

rem 0.00 2007-01-21-19:52 customized from odmjni100 ExtractWorkHeader.bat
rem      0.00

rem $Header: /ODMdev/info/odma/odmjni100/ExtractPendHeader.bat 1     07-01-21 19:59 Orcmid $

rem                   *** end of ExtractPendHeader.bat ***