@echo off
rem BuildCheckChoice.bat 0.01        UTF-8                   dh:2007-01-23
ECHO **   BuildCheckChoice.bat 0.00 COMPILING odmjni100 CONFIRMATION TEST
ECHO:         This Java application exercises the basic functions of
ECHO:         of the odmjni100 0.50beta classes to confirm correct access
ECHO:         to OdmNative interfaces and the ODMA API.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildCheckChoice.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST CheckChoice.java GOTO :FAIL1

erase CheckChoice.class CheckUtil.class
SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" CheckChoice.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   CheckChoice.class COMPILED
ECHO **   **************************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via RunCheckChoice.bat.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildCheckChoice.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding BuildCheckChoice.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE CheckChoice.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       BuildCheckChoice.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildCheckChoice into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA CLASS TO CONFIRM BASIC odmjni100 INTEGRATION
rem     Confirm basic cases of odmjni100 operation, using OdmJniBind to
rem     exercise the basic setup and confirm chooseDocument through to the
rem     ODMA Connection Manager and back.

rem 0.01 2007-01-23-22:58 Clean away *.class files before compiling.
rem 0.00 2007-01-23-18:18 Customize from BuildCheck03.bat 0.00

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/BuildCheckChoice.bat 6     07-01-23 23:05 Orcmid $

rem                   *** end of BuildCheckChoice.bat ***