@echo off
rem RunClicker.bat 0.01              UTF-8                    dh:2007-11-26
echo **   RunClickr.bat 0.01 PERFORMING Clicker APPLICATION
rem
rem       USAGE:
rem
rem           RunClicker [\lib.jar]
rem
rem       where  \lib.jar is the optional ODMJNI runtime jar to use at
rem                       the end of the classpath.
rem
rem       The basic classpath is set in OdmJava.bat.
rem
rem       IMPORTANT: For Clicker to run, the odmjni100.dll library must
rem          be available as well.  When using the development tree, the
rem          odmjni100.dll is expected in %OdmClasses%\info\odma\odmjni100
rem          When a runtime jar is used, odmjni100.dll is expected to be
rem          located in the same directory as the jar, %OdmClasses%
rem          directly.
rem
rem          This must be taken into consideration when customizing
rem          OdmJava.bat.

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Run
ECHO:
ECHO **   RunClicker.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Run
IF NOT EXIST OdmClicker.class GOTO :FAIL1
SET ERRORLEVEL=
rem         This version sets the library path on the command line.
rem         We cannot use .jar proximity in this arrangement of
rem         0.54-odmjni100\Clicker.
set ODMJNILIB=%OdmClasses%\info\odma\odmjni100
rem           The location of odmjni100.dll on the development-tree path
IF "%1"=="" GOTO :CheckPath
set ODMJNILIB=%OdmClasses%
rem           The location of odmjni100.dll adjacent to a .jar location
:CheckPath
IF NOT EXIST "%ODMJNILIB%\odmjni100.dll" GOTO :FAIL3
ECHO:
java -cp ".;%OdmClasses%%1" "-Djava.library.path=%ODMJNILIB%" OdmClicker
IF ERRORLEVEL 1 GOTO :FAIL2
EXIT /B 0

:FAIL0
ECHO:
ECHO **   EXECUTE RunClicker.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that directory.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding RunClicker.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE OdmClicker.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO:
EXIT /B 2


:FAIL2
ECHO:
ECHO **   ERRORS IN EXECUTION, ERRORLEVEL = %ERRORLEVEL%
ECHO **       Remedy depends on the available error messages from Java.
ECHO:
EXIT /B %ERRORLEVEL%

:FAIL3
ECHO:
ECHO **   THE odmjni100.dll FILE IS NOT PRESENT IN THE SAME LOCATION AS
ECHO **   THE info.odma.odmjni100 PACKAGE.  ACCORDING TO THE PARAMETERS
ECHO **   TO THIS SCRIPT, IT SHOULD BE IN THE DIRECTORY
ECHO **
ECHO **       %ODMJNILIB%
ECHO **
ECHO **   PLEASE REVIEW YOUR ODMJNI TEST CONFIGURATION AND THE CUSTOMIZATION
ECHO **   OF OdmJava.bat and RunClicker.bat.
ECHO:
EXIT /B 2

rem -----1---------2---------3---------4---------5---------6---------7----*

rem RUNNING odmjni100 OdmClicker SWING COORDINATION CHECK

rem 0.01 2007-11-26-17:40 Extended to provide more-careful parameterization
rem      and checking with regard to location of odmjni100.dll.
rem 0.00 2007-11-23-18:35 Customize from RunSwingApp.bat 0.01

rem $Header: /ODMdev/info/odma/odmjni100/0.54-odmjni100/clicker/RunClicker.bat 2     07-11-26 18:13 Orcmid $

rem                  *** end of RunClicker.bat ***