@echo off
rem ExtractViewHeader.bat 0.00       UTF-8                    dh:2007-01-09
ECHO **   ExtractViewHeader.bat 0.00 EXTRACT NATIVE METHOD HEADER
ECHO **       Obtain C/C++ declarations for OdmJniView native methods.

IF NOT EXIST OdmJava.bat GOTO :FAIL0
CALL OdmJava.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   ExtractViewHeader.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST OdmJniView.class GOTO :FAIL1

SET ERRORLEVEL=
rem     Use all ODMJNI packages and compile everything needed for
rem     OdmJniView.java
javah -classpath "%OdmClasses%" -o odmjni100v.h info.odma.odmjni100.OdmJniView
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   odmjni100v.h HEADER EXTRACTED
ECHO **   ****************************
echo:
echo:     There are no errors or warnings.  The header file can be used
echo:     as the basis for definitions to be used in programming and
echo:     compiling the odmjni100.dll file.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE ExtractViewHeader.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available in that location.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding ExtractViewHeader.bat is the current
ECHO **       working directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE OdmJniView.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this ExtractHeader
ECHO **       script.  ExtractViewHeader.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN JAVAH USAGE, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of ExtractViewHeader.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem EXTRACT THE odmjni100v.h HEADER FILE FOR THE NATIVE IMPLEMENTATIONS.
rem      Some of the native methods of odmjni100 are implemented as
rem      static methods on OdmJniView.  This procedure creates the
rem      C/C++ header file that provides prototypes for those particular
rem      implementations to be created.

rem 0.00 2007-01-09-19:01 customized from odmjni100 Extractheader.bat 0.00

rem $Header: /ODMdev/info/odma/odmjni100/ExtractViewHeader.bat 1     07-01-13 17:28 Orcmid $

rem                   *** end of ExtractViewHeader.bat ***