/* OdmJniWork.java 0.02              UTF-8                  dh:2007-11-15
 *
 * The OdmJniWork class implements the the OdmWorkingDocument interface for
 * a modifiable document.  It is a simple extension of OdmJniView.
 *
 */

package info.odma.odmjni100;

class OdmJniWork
        extends info.odma.odmjni100.OdmJniView
        implements info.odma.practical100.OdmBasicDocumentMetadata,
                   info.odma.practical100.OdmViewingDocument,
                   info.odma.practical100.OdmEditingDocument,
                   info.odma.practical100.OdmWorkingDocument

{   /* Class instance construction

       The following instance variables are carried in the OdmJniView
       super instance with package visibility to OdmJniWork:

       nullDocument - the OdmNullCache provided to the constructor

       rNativeDocument - the disguised reference to an IodmWorking100
            interface that implements the document instance this
            OdmJniWork delivers via an OdmWorkingDocument interface

       isAvailable - true until our release.

       resetProps() is used to flush the OdmJniView property cache
            whenever a commitChanges is performed.


       */


    OdmJniWork(long rNativeDoc, info.odma.practical100.OdmNull nullDoc)
    {   /* We simply expand the OdmNullDocument operation */

        /* Preconditions:
                This constructor is never used unless rNativeDoc
                is a disguised interface pointer for a successfully-
                created Native document interface to an already-
                opened and modifiable document.
                */

        super(rNativeDoc, nullDoc);
            /* Build atop OdmJniView */

        } /* OdmJniView */


    /* OdmInterface Interface Method Implementations
     * ---------------------------------------------
     */

    public java.lang.String interfaceImplementation()
    {
        return "ODMJNI 1.0 OdmJniWork 0.02 OdmWorkingDocument";
            /* Over-ride with our identification. */

        } /* interfaceImplementation */

    /* The following methods are implemented by the OdmJniView
       super instance:

            available()

            release()

            finalize()

            formatCheck()

       */



    /* OdmDocument Interface Method Implementations
     * --------------------------------------------
     *
     *      operationSucceeded() is properly supplied by OdmJniView.
     *
     *      localOperationRequested() is also supplied by OdmJniView.
     */



    /* OdmViewingDocument Interface Method Implementations
     * ---------------------------------------------------
     *
     *  All of these methods are as implemented by OdmJniView.  The
     *  only difference in their behavior is as the result of the
     *  OdmJniWork construction and use of resetProps by commitChanges.
     *
     *         docID() only cached until next commitChanges
     *   docLocation()          "
     *   windowTitle()          "
     *     dmsAuthor()          "
     *    dmsDocName()          "
     *    dmsDocType()          "
     * dmsFormatName()          "
     *
     * and transferToNewDocument is implemented by OdmJniView too.
     * DEPRECATED: This function will still be implemented by OdmJniView,
     * but on behalf of the OdmWorkingDocument interface, not OdmViewing-
     * Document.
     */


    public boolean viewOnly()
    {   /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
         * DEPRECATED: This implementation can be removed in 0.60 when
         * it is not required by OdmViewingDocument.
         * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
         */

        return notChangeable();

        } /* viewOnly */



    /* OdmEditingDocument Interface Method Implementations
     * ---------------------------------------------------
     */

    public boolean notChangeable()
    {
        if (rNativeDocument == 0) return super.notChangeable();
            /* If we are released, use the JniView case.
               */

        return false;

        } /* notChangeable */


    public boolean commitChanges()
    {
        if (rNativeDocument == 0) return super.commitChanges();
                /* Null behavior if we are released */

        resetProps();
        return jniCommitChanges(rNativeDocument);

        } /* commitChanges */



    private static native boolean jniCommitChanges(long rIodmWorking);
        /* The implementation fully provided by the native method. */


    /* OdmWorkingDocument Interface Method Implementations
     * ---------------------------------------------------
     *
     * The transferToNewDocument implementation of OdmJniView is usable
     * for OdmWorkingDocument at all times.
     */


    static

        {   /* Static initialization of this class specifies the
               loading of the only DLL used with odmjni100. */

            System.loadLibrary("odmjni100");

            } /* static initialization */

    } /* OdmJniView */



/* 0.02 2007-11-15-18:37 Adjust to reflect the 0.59 changes, add
        viewOnly and notChangeable implementations here, and also
        address the staging into 0.60.
   0.01 2007-11-10-16:55 Update documentation to reflect implementation
        of formatCheck by the super class with inheritance here.
   0.00 2007-01-13-16:43 Create simple extension of OdmJniView 0.08 to
        make OdmJniWork.  We just peel away a copy of OdmJniView and add
        in the commitChanges() operation.

   $Header: /ODMdev/info/odma/odmjni100/OdmJniWork.java 3     07-11-15 18:45 Orcmid $
   */

/*        *** end of info.odma.practical100.OdmJniWork.java ***         */