@echo off
rem BuildCheckKnown.bat 0.00        UTF-8                   dh:2007-03-10
ECHO **   BuildCheckKnown.bat 0.00 COMPILING odmjni100 CONFIRMATION TEST
ECHO:         This Java application exercises the basic functions of
ECHO:         of the odmjni100 0.57beta classes to confirm correct access
ECHO:         to OdmNative interfaces, the ODMA API, and openKnownDocument.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildCheckKnown.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST CheckKnown.java GOTO :FAIL1

erase CheckKnown.class CheckUtil.class
SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" CheckKnown.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   CheckKnown.class COMPILED
ECHO **   *************************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via RunCheckKnown.bat.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildCheckKnown.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding BuildCheckKnown.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE CheckKnown.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this script.
ECHO **       BuildCheckKnown.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildCheckKnown into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA CLASS TO CONFIRM COMPLETED odmjni100 INTEGRATION
rem     Confirm basic cases of odmjni100 operation, using OdmJniBind to
rem     exercise the basic setup, confirming all practical100 methods except
rem     acceptNewDocument in a Java console application operating to the
rem     ODMA Connection Manager and back.

rem 0.00 2007-03-10-12:51 Customized from BuildCheckChoice.bat 0.01

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/BuildCheckKnown.bat 1     07-03-10 13:00 Orcmid $

rem                   *** end of BuildCheckKnown.bat ***