@echo off
rem ExtractUtilHeader.bat 0.00       UTF-8                    dh:2007-01-24
ECHO **   ExtractUtilHeader.bat 0.00 EXTRACT NATIVE METHOD HEADER
ECHO **       Obtain C/C++ declarations for CheckUtil native methods.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   ExtractUtilHeader.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST CheckUtil.class GOTO :FAIL1

SET ERRORLEVEL=
rem     Just extract default/local package dependency on CheckUtil.class
javah  -o CheckUtil.h CheckUtil
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   CheckUtil.h HEADER EXTRACTED
ECHO **   ****************************
echo:
echo:     There are no errors or warnings.  The header file can be used
echo:     as the basis for definitions to be used in programming and
echo:     compiling the CheckUtil.dll file.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE ExtractUtilHeader.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available above that location.
ECHO **       Verify your odmjni100 configuration and ensure that the
ECHO **       directory holding ExtractUtilHeader.bat is the current
ECHO **       working directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE CheckUtil.class FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this ExtractHeader
ECHO **       script.  ExtractUtilHeader.bat has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN JAVAH USAGE, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of ExtractUtilHeader.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem EXTRACT THE CheckUtil.h HEADER FILE FOR THE NATIVE IMPLEMENTATIONS.

rem 0.00 2007-01-24-13:57 customized from odmjni100 ExtractAppHeader.bat
rem      0.00

rem $Header: /ODMdev/info/odma/odmjni100/test/Check04/ExtractUtilHeader.bat 1     07-01-24 14:52 Orcmid $

rem                   *** end of ExtractUtilHeader.bat ***