@echo off
rem BuildSetup02.bat 0.00            UTF-8                    dh:2006-11-28
ECHO **   BuildSetup02.bat 0.01 COMPILING Setup02.java odmjni100 TEST
ECHO:         This Java application exercises the basic functions of
ECHO:         of the odmjni100 classes to confirm correct access to
ECHO:         OdmNative interfaces and the ODMA API.

IF NOT EXIST ..\..\OdmJava.bat GOTO :FAIL0
pushd ..\..\
CALL OdmJava.bat
popd
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **   BuildSetup02.bat ABORTED.  SEE OdmJava.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST Setup02.java GOTO :FAIL1

SET ERRORLEVEL=
javac -cp ".;%OdmClasses%" Setup02.java
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **   Setup02.class COMPILED
ECHO **   **********************
echo:
echo:     There are no errors or warnings.  This program can be run
echo:     via RunSetup02.bat.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **   EXECUTE BuildSetup02.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO **       The OdmJava.bat script must be available two levels above.
ECHO **       Verify your Setup02 configuration and ensure that the
ECHO **       directory holding BuildSetup02.bat is the current working
ECHO **       directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **   THE Setup02.java FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO **       The file should be in the same directory as this BuildSetup02
ECHO **       script.  BuildSetup02 has aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **   ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo **       To capture a log, run with redirection to a file or pipe the
echo **       result of BuildSetup02 into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD JAVA CLASS TO CONFIRM BASIC odmjni100 INTEGRATION
rem     Confirm basic cases of odmjni100 operation, using OdmJniBind to
rem     exercise the basic setup and confirm operation through to the
rem     ODMA Connection Manager.

rem 0.00 2006-11-28-19:05 Customize from the Setup01 BuildClass01.bat,
rem      with the javac command line based on that of practical100
rem      BuildTest.bat 0.04.

rem $Header: /ODMdev/info/odma/odmjni100/test/setup02/BuildSetup02.bat 1     06-11-28 19:10 Orcmid $

rem                     *** end of BuildClass01.bat ***