/* info.odma.practical100.odmPendingDocument.java             0.05alpha
 * An OdmPendingDocument interface is returned by operations that request
 * creation of a new ODMA DMS managed document.  Interface methods must
 * be used to determine whether or not it is possible to submit the
 * document content and what further operations are appropriate.*/

package info.odma.practical100;

public interface OdmPendingDocument extends OdmDocument
{   /* corresponding to a new document that the ODMA DMS is prepared to
       accept from the application.  If the operation that delivers this
       interface is unsuccessful, operationSucceeded() will be false and
       there will be a null response for these functions.
       Otherwise, the original values will persist until release(), if any.
       */

    java.lang.String docSubmissionLocation();
        /* For a successful request to create a new managed document,
           docSubmissionLocation() is a string of the location in the
           local file system where the new document's content may be
           placed for pickup by the ODMA DMS.
               When the operation that returned this Document interface
           is unsuccessful, a null String reference will be returned.
               Null response: null
           */

    /* FIX ME: There are additional operations that are performed,
       mainly for submitting the document content to the DMS and then
       performing further operations with the managed document that is
       then established.
       */

    } /* OdmPendingDocument */


/* 0.01 2006-10-22-16:50 Customize for 0.05alpha and obtain clean compile.
   0.00 2006-10-20-17:02 Derive New Class from the 0.01alpha Document
        interface.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmPendingDocument.java 1     06-10-22 16:51 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmPendingDocument.java ***    */