@echo off
rem BuildDLL.bat 0.01                UTF-8                    dh:2006-11-29
ECHO **** BuildDLL.bat 0.01 COMPILING odmjni100.dll

IF NOT EXIST OdmJNI.bat GOTO :FAIL0
CALL OdmJNI.bat
IF NOT ERRORLEVEL 2 GOTO :Compile
ECHO **** BuildDLL.bat ABORTED.  SEE THE OdmJNI.bat ERROR MESSAGES.
ECHO:
EXIT /B %ERRORLEVEL%

:Compile
IF NOT EXIST odmjni100.cpp GOTO :FAIL1

SET ERRORLEVEL=
cl /WX /MT /LD odmjni100.cpp OdmNative100.obj user32.lib /link /MANIFEST:NO
if ERRORLEVEL 1 GOTO :FAIL2

echo:
echo **** odmjni100.dll COMPILED
echo **** **********************
echo:
echo:     There are no errors or warnings.  This DLL can be used via
echo:     Java package info.odma.odmjni100 classes that make use of
echo:     the native methods in static package class OdmJniBind.
echo:
EXIT /B 0


:FAIL0
ECHO:
ECHO **** EXECUTE BuildDLL.bat IN THE DIRECTORY THAT HOLDS IT.
ECHO ****     The OdmJNI.bat script must be available in that location.
ECHO ****     Verify your odmjni100 configuration and ensure that the
ECHO ****     directory holding BuildDLL.bat is the current working
ECHO ****     directory before the script is invoked.
ECHO:
EXIT /B 2


:FAIL1
ECHO:
ECHO **** THE odmjni100.cpp FILE IS NOT PRESENT IN THE CURRENT DIRECTORY
ECHO ****     The file should be in the same directory as this BuildDLL
ECHO ****     script.  BuildDLL.bat is aborted.
ECHO:
EXIT /B 2


:FAIL2
echo:
echo **** ERRORS OR WARNINGS IN COMPILATION, ERRORLEVEL = %ERRORLEVEL% ****
echo ****     To capture a log, run with redirection to a file or pipe the
echo ****     result of BuildDLL.bat into a program like "more."
echo:
EXIT /B %ERRORLEVEL%


rem -----1---------2---------3---------4---------5---------6---------7----*

rem BUILD DLL FROM C++ LANGUAGE IMPLEMENTATION OF odmjni100 METHODS.
rem This script builds the DLL that carries implementations of all
rem native methods declared in the odmjni100 classes.


rem 0.01 2006-11-29-16:68 Check OdmNative100 BuildSetup04.bat and use
rem      similar technique to add OdmNative100.obj into the DLL build.
rem 0.00 2006-11-28-17:19 customized from odmjni100 BuildDLL01b.

rem $Header: /ODMdev/info/odma/odmjni100/BuildDLL.bat 2     06-11-29 16:53 Orcmid $

rem                         *** end of BuildDLL.bat ***