/* OdmNative100.hpp 0.20alpha        UTF-8                   dh:2006-11-25
 *
 *                OdmNative100 ENTRY AND INTERFACE DEFINITIONS
 *                ********************************************
 *
 * This header file defines the various OdmNative100 interfaces and the
 * entry to the OdmNative100 class factory function.  This function and the
 * interfaces to the COM objects it creates provide all of the OdmNative100
 * functionality.
 *
 *                         Copyright © 2006 NuovoDoc
 *
 *              This software is released under the Open
 *              Document Management API License 1.0, an open-
 *              source software license modeled on the BSD
 *              License template.
 *
 *              A copy of the license should accompany the
 *              source code that includes this file.  If the
 *              license has has been separated from the code,
 *              obtain a copy at <http://DMware.info/license/>.
 */

#ifndef ODMNATIVE100_H
#define ODMNATIVE100_H

#define OdmNative100_H_Version_ "0.20alpha OdmNative100.hpp " \
                                "2006-11-26T04:56Z"

    /* This is a preprocessor text about this header file.  It is a
       string value that can be incorporated into other text.
       */

#ifndef __cplusplus
#error  __FILE__ INTERFACE DEFINITIONS REQUIRE C++.  DON'T USE WITH C.
    /* XXX: We might fix this some day, but not now. */
#endif

#include <windows.h>

#include "Odma32types100.h"
    /* Stick with the ODMA 1.0 Types and Values definitions */


/*                        Define IodmNative IID Values
                          ***************************** */

    /*  Each interface has a globally-unique Interface ID (IID).  The
        IIDs are specified by Microsoft for the standard COM interfaces
        such as IUnknown.  For the IodmNative-unique interfaces, the IIDs
        have been generated using the GuidGen.exe tool provided with
        the Microsoft Platform SDK.
        */

#ifndef IID_IodmUnknown_
#define IID_IodmUnknown_ { 0x00000000, 0x0000, 0x0000, \
               { 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 } }

        /* This is the IID for the standard IUnknown interface. The
           distinct name is used to avoid confusion with any name given
           in <windows.h> and to also avoid assumption of where there
           might be a stored copy of the IID.  If it is necessary to
           store this or any other IID_Iodm..._ value, use something
           like

                static const IID IID_IodmUnknown = IID_IodmUnknown_ ;

           to make a private, local copy.  That's how it is done
           internal to the implementation of OdmNative classes.  There
           is no dependency on a shared library like UUID.lib even for
           such well-known IIDs as the one for IUnknown.
           */
#endif


#define IID_IodmApplication100_ { 0x9f3d1c5b, 0x2225, 0x4568, \
               { 0x9c, 0x34, 0xe4, 0xc3, 0x30, 0xd6, 0x10, 0x7e } }

        /* This IID represents both the signature and the contract for
           the 0.20alpha version of IodmApplication100.  Every time the
           signature and contract change for a version released to the
           wild, there will be a new IID.  This is a safeguard against
           calling for an implementation of a different interface contract
           than the one represented by this IID.

           Each caller must make their own stored copy of an IID with
           this value.  It is important to avoid  using a shared value
           that might also be the one employed by an implementation, losing
           the benefit of interface confirmation by query.

           Once an interface is frozen and is to be preserved as a distinct
           version, later versions will have new names as well as their own
           IIDs.  Generally, the only time an IID changes and the interface
           name remains unchanged is during alpha and beta releases of the
           interfaces, as in intermediate stages of IodmApplication100
           development.
           */


/*                     Define IodmNative Interfaces
                       **************************** */


interface IodmApplication100 : IUnknown
{   /* Inherit from IUnknown as required for all COM interfaces */

    virtual LPCSTR WINAPI interfaceImplementation(void) PURE;
        /* A constant '\0'-terminated char string of '\n'-separated lines
           that identify the version of I0dmApplication100 implementation.
           This constant is available only so long as the interface is
           held.  A copy must be made for use beyond that duration.
           */

    virtual BOOL WINAPI hasConMan(void) PURE;
        /* TRUE if the ODMA Connection Manager is available.  FALSE
           if the ODMA Connecction Manager cannot be linked.

           This value will not change.  There is no action that will
           change the result for a given IodmApplication100 interface
           reference.
           */

    virtual BOOL WINAPI hasDefaultDMS(void) PURE;
        /* TRUE if the ODMA Connection Manager is available and there is
           a default DMS for the current application.  FALSE otherwise.

           Again, this value will not change.  There is no action that
           will change the result for a given IodmApplication100 interface
           reference.

           It may still be possible to access a DMS by other means.  But
           operations that depend on a default DMS cannot succeed when
           hasDefaultDMS() is FALSE.
           */


    /* Implementation Note: There is no indication when the operations
       that determine these results are actually performed.  They must
       be determined at most once and the same result reported thereafter.

       It is recommended that implementations be "lazy" and only
       determine these conditions when the result is requested or when
       determination is a prerequisite to the performance of other
       operations.

       This delay is valuable for speeding up application initialization
       and when there is some concern about not having the ODMA Connection
       Manager loaded until the caller is operating under thread-safe conditions on a GUI thread.
       */


    virtual ODMSTATUS WINAPI
        selectDocID(LPSTR pszDocId, BOOL *pViewMode) PURE;

        /* Method for bringing up the ODMSelectDoc dialog and capturing
           the result.  The *pViewMode output is TRUE if the document
           should be opened in ViewMode.

           Possible ODMSTATUS values are:

                ODM_SUCCESS  there is a Document ID and *pViewMode
                             determines whether access should be in
                             ViewMode or else ModifyMode.

                 ODM_E_FAIL  There is a failure in usage or operation.

               ODM_E_CANCEL  The user has cancelled the operation.  See the
                             considerations about "stuck" cancel status
                             under the ODMSelectDoc description in
                             Odma32api100.h.

                ODM_E_NODMS  There is no (Default) DMS available to perform
                             this operation.

            ODM_E_APPSELECT  The user requests that the application perform
                             the non-ODMA operation for which this ODMA
                             operation was given the "first refusal."
            */


    };  /* IodmApplication100 */



/*                       Define OdmBindNative100 Entry
                         ***************************** */


HRESULT WINAPI
    OdmBindNative100(  const char pszAppId[],
                                     /* Clean Basic Latin string of
                                        the Application ID */
                           REFIID pIID,
                                     /* The requested interface */
                             void **ppIface
                                     /* The location to receive the
                                        Interface pointer or NULL */
                       );

        /* OdmBindNative100 constructs an OdmApplication object that
           is tied to the given Application ID.  This object provides an
           application face to the ODMA Connection Manager.  It and the
           objects produced by it are the only users of the ODMA API.  The
           application is expected to obtain all of its ODMA-aware behavior
           via the IodmNative interfaces provided for that purpose.

           If the construction is successful, OdmBindNative returns via the
           OdmApplication's IodmApplication::QueryInterface(piid, ppIface).
           At least IUnknown and IodmApplication100 are implemented by the
           object.
           */


/* More information about the construction of COM interfaces and their
   defining header files can be found in

       Rogerson, Dale.  Inside COM: Microsoft's Component Object Model.
           Microsoft Press (Redmond, WA: 1997).  ISBN 1-57231-349-8 pbk.

   For our needs, that simple style and the basic bottom-up structure
   with hand-crafted binary interfaces works just fine.

   The Microsoft Platform SDK has a set of COM Tutorial Samples that are
   also useful.  Look under Samples\Com\Fundamentals\TutSamp\TutorIAL.Htm
   */


/* 0.20 2006-11-25-20:56 Incorporated in the 0.20alpha OdmNative100 release.

   0.09 2006-11-23-14:32 Change selectDoc to selectDocID as more accurate.

   0.08 2006-11-22-22:32 Add pViewMode output for selectDoc method and
        document the operation.

   0.07 2006-11-22-19:00 Eliminate use of fixed-size arrays in the
        selectDoc prototype.

   0.06 2006-11-22-18:03 Switch from Odma.h to Odma32types100.h for
        ODMA types and values here.

   0.05 2006-11-21-15:12 Add provisional selectDoc method that can
        be used as a lead-in to known-document opening.

   0.04 2006-11-18-23:34 Add interfaceImplementation method to the
        IodmApplication100 interface and define OdmNativeVersion_ value.

   0.03 2006-11-16-21:02 Change OdmBindNative100 to C++ signature and
        use REFIID out of harmony with QueryInterface and other usages.

   0.02 2006-11-15-21:55 Rename to OdmNative100.hpp and begin tracking to
        definitions in OdmNative100.cpp.  The key interface settles out to
        be IodmApplication100 and the external entry into OdmNative100 is
        defined as OdmBindNative100.

   0.01 2006-11-15-17:58 Simplify to IodmNative.hpp and document the use of
        the IIDs and the individual interface functions.  We have committed
        to using C++ for simplicity and clarity.  There is no meaningful
        use outside of C++ for OdmNative.

   0.00 2006-11-14-18:50 Obtain the information that I need for the initial
        version.  Simply replicate IUnknown, adding only the simplest methods for initial operation.
        */

#endif ODMNATIVE100_H
/* $Header: /ODMdev/info/odma/OdmNative100/OdmNative100.hpp 11    06-11-25 21:06 Orcmid $
   */
/*                     *** end of OdmNative100.hpp ***                  */
