/* info.odma.practical100.OdmWorkingDocument.java               0.05alpha
 * An OdmWorkingDocument interface results from any operation that requests
 * access to an existing ODMA DMS managed document.  Interface methods must
 * be used to determine whether or not there is a document available and
 * what further operations are appropriate.
 */

package info.odma.practical100;

public interface OdmWorkingDocument extends OdmDocument
{   /* corresponding to an existing managed DMS document.  If the operation
       that delivers this interface is unsuccessful, operationSucceeded()
       will be false and there will be a null response for these functions.
       Otherwise, the original values will persist until release(), if any.
       */

    java.lang.String docID();
        /* For a successful document access, this method returns a string
           with the ODMA Document ID of the document whose content is
           delivered at docLocation().
               Null response: null
           */

    java.lang.String docLocation();
        /* For a successful document access, docLocation() is a string
           with the location in the local file system where the ODMA DMS
           has delivered a copy of the DMS-managed document content.
               Null response: null
           */

    /* FIX ME.  There are further operations for obtaining descriptive
       information about the current document, when the operation that
       delivered the interface was successful.  These will be filled in
       later.  They all produce null results when there is no document
       to use.
       */

    /* FIX ME: There are a few additional operations that can be performed,
       such as returning a modified document, releasing the document
       without any changes, and so on, that need to be defined.  For the
       initial null implementation, these are unimportant.
       */

    } /* odmWorkingDocument */


/* 0.04 2006-10-22-20:39 Make the interface public.
   0.03 2006-10-22-16:53 Clean up comments for better explanation of how
        OdmWorkingDocument is created and what data is stable when.
   0.02 2006-10-22-16:27 provide clean compile sufficient for 0.05alpha.
   0.01 2006-10-22-15:59 rename as OdmWorkingDocument and extend the
        new OdmDocument intermediate interface.  Treat as separate from
        the OdmPendingDocument interface which is now being added
   0.00 2006-10-18-22:38 alpha-level version for the first evolutionary
        prototype of ODMJNI components.  This interface is intended to
        become stable very quickly during early testing and application
        integration.

   $Header: /MyProjects/java/ODMdev/info/odma/practical100/OdmWorkingDocument.java 7     06-10-22 20:51 Orcmid $
   */

/*    *** end of info.odma.practical100.OdmWorkingDocument.java ***    */