/* Null00.java 0.04                  UTF-8              dh:2006-12-01 */

/* Null00 is a Java application for verifying the 0.05alpha level of the
 * info.odma.practical100.OdmNullConnection class, its interface, and the
 * null documents that it produces.
 *
 * This is not a comprehensive test for null behavior.
 */


import info.odma.practical100.*;


public class Null00
{/* Exercise the interfaces supplied by the OdmNullConnection 0.05 alpha
    level.  The following interfaces are confirmed:

          OdmConnection implemented by OdmNullConnection
     OdmPendingDocument delivered by OdmConnection.acceptNewDocument()
     OdmWorkingDocument delivered by OdmConnection.chooseDocument()

    We have not provided confirmation that there is the same result for
    OdmConnection.openKnownDocument(SomeDocID).  This and some other
    features would be useful to test when we are in the stabilization
    stage of ODMJNI 1.0 delivery.
    */


    private static void hello(IConOut console)
    {   /* Identify the application and what we are doing here.
           */

        console.println();
        console.println("Null00> "
                            + "0.04 OdmNullConnection Test");
        }


    private static final String indent = "        ";
            /* Indent spaces below       "Null00> ". */

    private static final String stars =  "      **** ";
            /* Used to highlight unexpected results */


    private static void goodbye(IConOut console)
    {   /* Announce completion of operation */

        console.println();
        console.println("Null00> exit");
        console.println();
        }


    private static final IConOut
        stdout = new ConWriter(java.lang.System.out);
                     /* use a default console-output implementation */




    public static void main(String[] args)
    {   /*  Console application for reading pairs of doubles and comparing
            them via Math.max and conditional expression.
            */
        hello(stdout);
            /*  identifying ourselves. */

        OdmConnection testConnection
                        = new OdmNullConnection("OdmNativeTest");

        stdout.println();

        showNullConnection(stdout, indent, testConnection);

        goodbye(stdout);
            /* confirming completion. */

        } /* main */


    private static void
        showNullConnection( IConOut out,
                            java.lang.String indent,
                            OdmConnection testConn )

    {/* Show what's expected, and what's not, by parts. */

        java.lang.String dentx = indent + "  ";

        out.println(indent + "> ANALYSIS OF NULL CONNECTION:");

        checkNullConnection(out, dentx, testConn);

        out.println();
        out.println(indent + "> > ANALYSIS OF NULL PENDING DOCUMENT:");
        out.println(indent + "    checking Null Connection "
                           + "acceptNewDocument()"
                           );

        OdmPendingDocument testPend = testConn.acceptNewDocument();

        checkNullPending(out, dentx + "  ", testPend);

        out.println();
        out.println(indent + "> > ANALYSIS OF NULL WORKING DOCUMENT:");
        out.println(indent + "    checking Null Connection "
                           + "chooseDocument()"
                           );

        OdmWorkingDocument testWork = testConn.chooseDocument();

        checkNullWorking(out, dentx + "  ", testWork);

        /* FIX ME: The way to handle testing of openKnownDocument() is
           to check to see if it is the same object returned as the
           implementation of testPend, and saying yes or no.  If they
           are the same, there is no reason to repeate everything,
           although confirming that they are/were the same is also an
           appropriate black-box test.
           */

        /* FIX ME: If a connection shows as available, we probably
           should stop after the connection report and not do any
           further poking around.
           */

        } /* showNullConnection */


    private static void
        checkNullInterface( IConOut out,
                            java.lang.String indent,
                            OdmInterface testIface)

    {   /* Check out all parts that shouldn't side-effect. */

        out.println(indent + testIface.interfaceImplementation());
        out.println(indent + "Object " + testIface);
        out.println();

        checkBoolean(out, indent + "connectionAvailable()",
                          false, testIface.connectionAvailable() );

        if (testIface.connectionAvailable())
             out.println(stars + "testing release() unsafe here.");
        else out.println(indent
                            + "release() is not checked.");
        /* FIXME: Fundamentally, release() must be checked after
           everything else, where all values are saved and then the
           difference, if any, following release() is checked for.
           */
        }


    private static void
        checkNullConnection(IConOut out,
                            java.lang.String indent,
                            OdmConnection testIface)

    {   /* Show the super class, then the connection parts. */

        checkNullInterface(out, indent, testIface);

        out.println();

        checkBoolean(out, indent + "dmsDefaultAvailable()",
                     false, testIface.dmsDefaultAvailable() );

        out.println(indent + "acceptNewdocument() not checked");
        out.println(indent + "chooseDocument() not checked");
        out.println(indent + "openKnownDocument() not checked");

        }


    private static void
        checkNullDocument(IConOut out,
                           java.lang.String indent,
                           OdmDocument testDocFace)

    {   /* Show the super class, then the connection parts. */

        checkNullInterface(out, indent, testDocFace);

        out.println();

        checkBoolean(out, indent + "dmsAvailable()",
                     false, testDocFace.dmsAvailable() );
        checkBoolean(out, indent + "operationSucceeded()",
                     false, testDocFace.operationSucceeded());
        checkBoolean(out, indent + "operationCancelled()",
                     false, testDocFace.operationCancelled());
        checkBoolean(out, indent + "localOperationRequested()",
                     true, testDocFace.localOperationRequested());

        }


    private static void
        checkNullPending(IConOut out,
                         java.lang.String indent,
                         OdmPendingDocument testPending)

    {   /* Show the super class, then the connection parts. */

        checkNullDocument(out, indent, testPending);

        out.println();

        checkString(out, indent + "docSubmissionLocation()",
                    null, testPending.docSubmissionLocation() );

        }


    private static void
        checkNullWorking(IConOut out,
                         java.lang.String indent,
                         OdmWorkingDocument testWorking)

    {   /* Show the super class, then the connection parts. */

        checkNullDocument(out, indent, testWorking);

        out.println();

        checkString(out, indent + "docID()",
                    null, testWorking.docID() );

        checkString(out, indent + "docLocation()",
                    null, testWorking.docLocation() );

        }


    private static void
        checkBoolean(IConOut out,
                     java.lang.String title,
                     boolean expected,
                     boolean actual )

    {   /* Report on Boolean match or not. */

        out.print(title + " = " + actual);

        if (expected == actual)
             out.println(", as expected.");
        else { out.println();
               out.println(stars + expected + " was expected." + stars);
               }

        }


    private static void
        checkString(IConOut out,
                    java.lang.String title,
                    java.lang.String expected,
                    java.lang.String actual )

    {   /* Report on String match or not. */

        out.print(title + " = " + actual);

        if (expected == actual)
             out.println(", as expected.");
        else { out.println();
               out.println(stars + expected + " was expected." + stars);
               }

        }




} /* Null00 */


/* 0.04 2006-12-01-20:54 Rename to Null00 and adjust to provide the same
        tests with any 0.05alpha upward-compatible OdmConnection and
        OdmNullConnection interfaces and classes.
   0.03 2006-10-24-00:10 Successful basic confirmation accomplished.
   0.02 2006-10-23-23:28 Complete checkover for reasonable 0.05alpha test.
   0.01 2006-10-23-21:32 Cleanups to get class paths and execution to go
        properly on skeletal showNullConnection method.
   0.00 2006-10-23-17:39 Confirm skeleton using abstracted ConIO and IConIO
        interfaces for console output of the structured results.

   $Header: /ODMdev/info/odma/practical100/test/Null00/Null00.java 10    06-12-01 21:19 Orcmid $
   */

/*                          *** end of Null00.java ***              */
