/* odmjni100.cpp 0.05                UTF-8                   dh:2006-11-30
 *
 *
 *                 IMPLEMENT THE NATIVE METHODS OF ODMJNI100
 *                 *****************************************
 *
 * This is the C++ Language implementation of the native-method DLL
 * for odmjni100.  It is developed progressively in line with the
 * expansion of info.odma.odmjni100 OdmJniBind class support for
 * different ODMA operations.
 */


#include <jni.h>
    /* For the standard JNI interface.  This interface will be the
       C++ version when building odmjni100.dll.
       */

#include "odmjni100x.h"
    /* Rely on the annotated cumulatively-updated header. */

#include <windows.h>
    /* For native interfaces and COM-related definitions. */

#include "OdmNative100.hpp"
    /* For functions and classes of OdmNative and IodmNative. */

#include "Odma32types100.h"
    /* For ODMA-specific types and values that we rely on and produce. */



JNIEXPORT
    jint JNICALL
         Java_info_odma_odmjni100_OdmJniBind_jniVersion
             (  JNIEnv *pIenv,       /* JNI environment interface */
                jclass pThisClass    /* not used */
                )

{   /* Return the JNI Version Number m.n, coded as 0x000m000n.
       pIenv is a ppv. That is, JNIEnv is a pv, and what's passed
       in is a ppv.  In C++, Ienv is a class with interface methods.
       */

    return pIenv->GetVersion();

    } /* jniVersion */



static const IID IID_IodmApplication100 = IID_IodmApplication100_ ;
    /* IodmApplication100 IID of the current header level. */


JNIEXPORT
    jlong JNICALL
        Java_info_odma_odmjni100_OdmJniBind_getIodmNative
            (   JNIEnv *pIenv,      /* JNI environment interface */
                jclass pThisClass,  /* not used */
               jstring jAppId       /* The Application ID */
               )

{   /* This procedure binds an IodmApplication100 interface using
       the OdmBindNative100 function.
       */

    const char *pszAppId
        = pIenv -> GetStringUTFChars(jAppId, NULL);
            /* Get pointer to the UTF (presumably-ASCII string.
               XXX: We let OdmBindNative100 check the string for
               us.  It should have been checked by OdmJniBind before
               we got to here. */

    IUnknown *pIUnk = NULL;
            /* receptacle for the pIodmNative returned from
               OdmBindNative100.  We ask for IodmApplication100
               here so that other code doesn't have to query
               interface and we have a check on the proper version
               by IID match-up.
               */

    HRESULT rc = OdmBindNative100(  pszAppId,
                                    IID_IodmApplication100,
                                    (void **) &pIUnk
                                    );
            /* If everything is working, we get an interface that is
               reserved for us (and hence our caller). */

    pIenv -> ReleaseStringUTFChars(jAppId, pszAppId);
            /* Let go of the AppID UTF - we don't need it any longer. */

    if (SUCCEEDED(rc)) return (jlong) pIUnk;
            /* Hand out the disguised pIUnk that we succeeded in getting.*/

    return (jlong) ODM_E_FAIL;
            /* Anything else produces a low-numbered value. */

    } /* getIodmNative */



JNIEXPORT
    jlong JNICALL
        Java_info_odma_odmjni100_OdmJniBind_holdNativeInterface
            (   JNIEnv *pIenv,      /* not used */
                jclass pThisClass,  /* not used */
                 jlong rIodmNative  /* A disguised Native pointer */
                )
{   /* This is a standard IUnknown::AddRef() operation.  It could
       also be a QueryInterface as a way of also normalizing the
       interface, but we will go for speed instead. */

    if (rIodmNative == (rIodmNative & 0x1F))
         return 0;
            /* XXX: Simply ignore non-pointer values. */

    ((IUnknown *) rIodmNative) -> AddRef();

    return rIodmNative;

    } /* holdNativeInterface */



JNIEXPORT
    void JNICALL
        Java_info_odma_odmjni100_OdmJniBind_freeNativeInterface
            (   JNIEnv *pIenv,      /* not used */
                jclass pThisClass,  /* not used */
                 jlong rIodmNative  /* a disguised Native pointer */
                )
{   /* Perform a standard IUnknown::Release() using the disguised
       interface reference we are handed.
       */

    if (rIodmNative == (rIodmNative & 0x1F)) return;
            /* XXX: Simply ignore non-pointer values. */

    ((IUnknown *) rIodmNative) -> Release();

    } /* freeNativeInterface */



JNIEXPORT
    jboolean JNICALL
        Java_info_odma_odmjni100_OdmJniBind_hasConMan
            (   JNIEnv  *pIenv,     /* not used */
                jclass  pThisClass, /* not used */
                 jlong  rIodmNative /* a disguised Native pointer */
                )
{   /* Perform IodmNative100::hasConMan() and that's all we care about. */

    /* XXX: Technically, we should do a query interface here, but we
       assert that we have the right rIodmNative every time this
       method is called.
       */

    return ((IodmApplication100 *) rIodmNative) -> hasConMan();


    } /* hasConMan */



JNIEXPORT
    jboolean JNICALL
        Java_info_odma_odmjni100_OdmJniBind_hasDefaultDMS
            (   JNIEnv *pIenv,      /* not used */
                jclass pThisClass,  /* not used */
                 jlong rIodmNative  /* a disguised Native pointer */
                )
{   /* Perform IodmNative100::hasDefaultDMS() and we're done.
       */

    return ((IodmApplication100 *) rIodmNative) -> hasDefaultDMS();

    } /* hasDefaultDMS */



JNIEXPORT
    jlong JNICALL
        Java_info_odma_odmjni100_OdmJniBind_selectDoc
            (   JNIEnv *pIenv,      /* not used */
                jclass pThisClass,  /* not used */
                 jlong rIodmNative  /* a disguised Native pointer */
                )
{   /* Use IodmNative100::selectDocID to connect to the DMS and
       return the selection from the user.
       */

    if (rIodmNative == (rIodmNative & 0x1F)) return 0;
            /* XXX: Simply ignore non-pointer values. */

    char pszDocId[ODM_DOCID_MAX+2]={'\0'};
            /* FIXME: We need serious buffer over-run
               protection here.
               */

    BOOL viewMode = TRUE;

    ODMSTATUS rc = ((IodmApplication100 *) rIodmNative)
                        -> selectDocID(pszDocId, &viewMode);

    return (jlong) rc;
        /* FIXME: We are returning status no matter what until
              there is something better to do.  We discard any
              document ID because there is no object to give it
              to at this point. (It will be a parameter to the
              constructor for a native working-document instance.)
              */


    } /* selectDoc */




/* 0.05 2006-11-30-00:42 Add selectDoc implementation.  This is provisional
        for now because we don't have any OdmNative document objects to
        instantiate yet.

   0.04 2006-11-29-21:56 Add hadDefaultDMS implementation.

   0.03 2006-11-29-20:58 Add hasConMan implementation.

   0.02 2006-11-29-19:00 Add holdNativeInterface implementation.

   0.01 2006-11-29-13:10 Add getIodmNative and freeNativeInterface.  These
        provide enough to instantiate an OdmConnection implementation.  Now
        there are 69,632 bytes in the DLL.

   0.00 2006-11-28-17:04 Strip down from odmjni100 0.06 to include only
        the jniVersion() method for initial confirmation of DLL location.
        The DLL compiles to the magical 49,152 bytes.

   $Header: /ODMdev/info/odma/odmjni100/odmjni100.cpp 6     06-11-30 1:06 Orcmid $
   */

/*                         *** end of odmjni100.cpp ***                  */
